/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.utils;

import java.util.Collection;
import java.util.Map;
import org.monarchinitiative.phenol.io.utils.TrieNode;

class Trie {
    private final TrieNode root = new TrieNode();

    Trie(Collection<String> values) {
        values.forEach(this::insert);
    }

    void insert(String word) {
        TrieNode node = this.root;
        int length = word.length();
        for (int level = 0; level < length; ++level) {
            char c;
            Map<Character, TrieNode> children = node.children();
            TrieNode child = children.get(Character.valueOf(c = word.charAt(level)));
            if (child != null) {
                node = child;
                continue;
            }
            TrieNode novel = new TrieNode();
            children.put(Character.valueOf(c), novel);
            node = novel;
        }
        node.setLeaf(true);
    }

    String search(String value) {
        char c;
        Map<Character, TrieNode> children;
        TrieNode child;
        StringBuilder result = new StringBuilder();
        TrieNode node = this.root;
        int prevMatch = 0;
        int length = value.length();
        for (int level = 0; level < length && (child = (children = node.children()).get(Character.valueOf(c = value.charAt(level)))) != null; ++level) {
            result.append(c);
            node = child;
            if (!node.isLeaf()) continue;
            prevMatch = level + 1;
        }
        return node.isLeaf() ? result.toString() : result.substring(0, prevMatch);
    }
}

