/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.io.impl;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.monarchinitiative.sgenes.gtf.io.gtf.GtfRecord;
import org.monarchinitiative.sgenes.gtf.io.impl.BaseGeneIterator;
import org.monarchinitiative.sgenes.gtf.model.Biotype;
import org.monarchinitiative.sgenes.gtf.model.EvidenceLevel;
import org.monarchinitiative.sgenes.gtf.model.GencodeGene;
import org.monarchinitiative.sgenes.gtf.model.GencodeMetadata;
import org.monarchinitiative.sgenes.gtf.model.GencodeTranscript;
import org.monarchinitiative.sgenes.gtf.model.impl.gencode.GencodeGeneImpl;
import org.monarchinitiative.sgenes.model.GeneIdentifier;
import org.monarchinitiative.sgenes.model.TranscriptIdentifier;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;
import org.monarchinitiative.svart.assembly.GenomicAssembly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GencodeGeneIterator
extends BaseGeneIterator<GencodeGene, GencodeMetadata, GencodeTranscript> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GencodeGeneIterator.class);
    private static final Set<String> MANDATORY_GENE_ATTRIBUTE_NAMES = Set.of("gene_type", "gene_name", "level");
    private static final Set<String> MANDATORY_TRANSCRIPT_ATTRIBUTE_NAMES = Set.of("transcript_type", "transcript_name", "level");
    private static final Set<String> MANDATORY_EXON_ATTRIBUTE_NAMES = Set.of("exon_id", "exon_number");
    private static final String NCBI_GENE_ID_IS_NA = null;

    GencodeGeneIterator(Path gencodeGtfPath, GenomicAssembly genomicAssembly) {
        super(gencodeGtfPath, genomicAssembly, MANDATORY_TRANSCRIPT_ATTRIBUTE_NAMES, MANDATORY_EXON_ATTRIBUTE_NAMES);
    }

    @Override
    protected Optional<GeneIdentifier> parseGeneIdentifier(String geneId, GtfRecord gene) {
        String hgncId = gene.firstAttribute("hgnc_id");
        return Optional.of(GeneIdentifier.of((String)geneId, (String)gene.firstAttribute("gene_name"), (String)hgncId, (String)NCBI_GENE_ID_IS_NA));
    }

    @Override
    protected Optional<GencodeMetadata> parseGeneMetadata(String geneId, GtfRecord gene) {
        Optional<Biotype> biotype = GencodeGeneIterator.parseBiotype(gene.firstAttribute("gene_type"));
        if (biotype.isEmpty()) {
            LOGGER.warn("Unable to parse biotype level `{}` for gene `{}`", gene.attribute("gene_name"), (Object)geneId);
            return Optional.empty();
        }
        Optional<EvidenceLevel> evidenceLevel = GencodeGeneIterator.parseEvidenceLevel(gene.firstAttribute("level"));
        if (evidenceLevel.isEmpty()) {
            LOGGER.warn("Unable to parse evidence level `{}` for gene `{}`", gene.attribute("level"), (Object)geneId);
            return Optional.empty();
        }
        return Optional.of(GencodeMetadata.of(biotype.get(), evidenceLevel.get(), gene.tags()));
    }

    private static Optional<EvidenceLevel> parseEvidenceLevel(String level) {
        switch (level) {
            case "1": {
                return Optional.of(EvidenceLevel.VERIFIED);
            }
            case "2": {
                return Optional.of(EvidenceLevel.MANUALLY_ANNOTATED);
            }
            case "3": {
                return Optional.of(EvidenceLevel.AUTOMATICALLY_ANNOTATED);
            }
        }
        return Optional.empty();
    }

    @Override
    protected Optional<GencodeTranscript> processTranscript(String txId, GtfRecord tx, List<GtfRecord> exonRecords, GtfRecord startCodon, GtfRecord stopCodon) {
        TranscriptIdentifier txIdentifier = TranscriptIdentifier.of((String)txId, (String)tx.firstAttribute("transcript_name"), (String)tx.firstAttribute("ccdsid"));
        Optional<GencodeMetadata> metadata = GencodeGeneIterator.parseTranscriptMetadata(txId, tx);
        if (metadata.isEmpty()) {
            return Optional.empty();
        }
        List<Coordinates> exons = GencodeGeneIterator.processExons(exonRecords);
        Optional<Coordinates> cdsCoordinates = GencodeGeneIterator.createCdsCoordinates(startCodon, stopCodon, txId, tx);
        return Optional.of(GencodeTranscript.of(txIdentifier, tx.location(), exons, metadata.get(), cdsCoordinates.orElse(null)));
    }

    @Override
    protected GencodeGene newGeneInstance(GeneIdentifier geneIdentifier, GenomicRegion location, List<GencodeTranscript> transcripts, GencodeMetadata gencodeMetadata) {
        return GencodeGeneImpl.of(geneIdentifier, location, transcripts, gencodeMetadata);
    }

    private static Optional<GencodeMetadata> parseTranscriptMetadata(String txId, GtfRecord tx) {
        Optional<EvidenceLevel> level = GencodeGeneIterator.parseEvidenceLevel(tx.firstAttribute("level"));
        if (level.isEmpty()) {
            LOGGER.warn("Unable to parse evidence level `{}` for gene `{}`", tx.attribute("level"), (Object)txId);
            return Optional.empty();
        }
        Optional<Biotype> biotype = GencodeGeneIterator.parseBiotype(tx.firstAttribute("transcript_type"));
        if (biotype.isEmpty()) {
            LOGGER.warn("Unable to parse biotype level `{}` for gene `{}`", tx.attribute("gene_name"), (Object)txId);
            return Optional.empty();
        }
        return Optional.of(GencodeMetadata.of(biotype.get(), level.get(), tx.tags()));
    }
}

