/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.model;

public enum Biotype {
    unknown,
    protein_coding,
    ambiguous_orf,
    MT,
    processed_transcript,
    ncRNA,
    miRNA(ncRNA),
    rRNA(ncRNA),
    sRNA(ncRNA),
    tRNA(ncRNA),
    piRNA(ncRNA),
    scRNA(ncRNA, sRNA),
    snRNA(ncRNA, sRNA),
    snoRNA(ncRNA, sRNA),
    scaRNA(ncRNA, sRNA, snoRNA),
    vaultRNA(ncRNA),
    misc_RNA,
    MT_rRNA(MT, rRNA),
    MT_tRNA(MT, tRNA),
    nonsense_mediated_decay,
    non_stop_decay(nonsense_mediated_decay),
    lncRNA(processed_transcript),
    non_coding(lncRNA),
    three_prime_overlapping_ncRNA(lncRNA),
    antisense(lncRNA),
    lincRNA(lncRNA),
    retained_intron,
    sense_intronic(lncRNA),
    sense_overlapping(lncRNA),
    macro_lncRNA(lncRNA),
    bidirectional_promoter_lncRNA(lncRNA),
    pseudogene,
    unitary_pseudogene(pseudogene),
    polymorphic_pseudogene(pseudogene),
    processed_pseudogene(pseudogene),
    unprocessed_pseudogene(pseudogene),
    transcribed_processed_pseudogene(pseudogene, processed_pseudogene),
    transcribed_unprocessed_pseudogene(pseudogene, unprocessed_pseudogene),
    transcribed_unitary_pseudogene(pseudogene, unitary_pseudogene),
    translated_processed_pseudogene(pseudogene, processed_pseudogene),
    translated_unprocessed_pseudogene(pseudogene, unprocessed_pseudogene),
    retrotransposed_pseudogene(pseudogene),
    IG_gene,
    IG_C_gene(IG_gene),
    IG_D_gene(IG_gene),
    IG_J_gene(IG_gene),
    IG_LV_gene(IG_gene),
    IG_V_gene(IG_gene),
    TR_gene,
    TR_C_gene(TR_gene),
    TR_J_gene(TR_gene),
    TR_V_gene(TR_gene),
    TR_D_gene(TR_gene),
    IG_pseudogene(IG_gene),
    IG_C_pseudogene(IG_pseudogene),
    IG_J_pseudogene(IG_pseudogene),
    IG_V_pseudogene(IG_pseudogene),
    TR_pseudogene,
    TR_C_pseudogene(TR_pseudogene),
    TR_J_pseudogene(TR_pseudogene),
    TR_V_pseudogene(TR_pseudogene),
    TR_D_pseudogene(TR_pseudogene);

    private final Biotype baseType;
    private final Biotype subType;
    private final Biotype subSubType;

    private Biotype() {
        this.baseType = this;
        this.subType = this;
        this.subSubType = this;
    }

    private Biotype(Biotype parent) {
        this.baseType = parent;
        this.subType = this;
        this.subSubType = this;
    }

    private Biotype(Biotype parent, Biotype subType) {
        this.baseType = parent;
        this.subType = subType;
        this.subSubType = this;
    }

    private Biotype(Biotype parent, Biotype subType, Biotype subSubType) {
        this.baseType = parent;
        this.subType = subType;
        this.subSubType = subSubType;
    }

    public Biotype getSubSubType() {
        return this.subSubType;
    }

    public Biotype getBaseType() {
        return this.baseType;
    }

    public Biotype getSubType() {
        return this.subType;
    }
}

