/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.model.impl.gencode;

import java.util.List;
import java.util.Objects;
import org.monarchinitiative.sgenes.gtf.model.GencodeMetadata;
import org.monarchinitiative.sgenes.gtf.model.impl.gencode.GencodeNoncodingTranscript;
import org.monarchinitiative.sgenes.model.CodingTranscript;
import org.monarchinitiative.sgenes.model.TranscriptIdentifier;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;

public class GencodeCodingTranscript
extends GencodeNoncodingTranscript
implements CodingTranscript {
    private final Coordinates cdsCoordinates;

    public static GencodeCodingTranscript of(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons, Coordinates cdsCoordinates, GencodeMetadata gencodeMetadata) {
        return new GencodeCodingTranscript(id, location, exons, cdsCoordinates, gencodeMetadata);
    }

    private GencodeCodingTranscript(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons, Coordinates cdsCoordinates, GencodeMetadata gencodeMetadata) {
        super(id, location, exons, gencodeMetadata);
        this.cdsCoordinates = Objects.requireNonNull(cdsCoordinates, "CDS coordinates must not be null");
    }

    public Coordinates cdsCoordinates() {
        return this.cdsCoordinates;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GencodeCodingTranscript that = (GencodeCodingTranscript)o;
        return Objects.equals(this.cdsCoordinates, that.cdsCoordinates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cdsCoordinates);
    }

    @Override
    public String toString() {
        return "GencodeCodingTranscript{cdsCoordinates=" + this.cdsCoordinates + "} " + super.toString();
    }
}

