/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.model.impl.gencode;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.monarchinitiative.sgenes.gtf.model.Biotype;
import org.monarchinitiative.sgenes.gtf.model.EvidenceLevel;
import org.monarchinitiative.sgenes.gtf.model.GencodeGene;
import org.monarchinitiative.sgenes.gtf.model.GencodeTranscript;
import org.monarchinitiative.sgenes.gtf.model.GencodeTranscriptMetadata;
import org.monarchinitiative.sgenes.model.GeneIdentifier;
import org.monarchinitiative.sgenes.model.base.BaseGene;
import org.monarchinitiative.svart.GenomicRegion;

public class GencodeGeneImpl
extends BaseGene
implements GencodeGene {
    private final List<? extends GencodeTranscript> transcripts;
    private final GencodeTranscriptMetadata metadata;

    public static GencodeGeneImpl of(GeneIdentifier id, GenomicRegion location, List<GencodeTranscript> transcripts, GencodeTranscriptMetadata metadata) {
        return new GencodeGeneImpl(id, location, transcripts, metadata);
    }

    private GencodeGeneImpl(GeneIdentifier id, GenomicRegion location, List<GencodeTranscript> transcripts, GencodeTranscriptMetadata metadata) {
        super(id, location);
        this.transcripts = Objects.requireNonNull(transcripts, "Transcripts must not be null");
        if (this.transcripts.isEmpty()) {
            throw new IllegalArgumentException("Transcripts must not be empty");
        }
        this.metadata = Objects.requireNonNull(metadata, "Gencode metadata must not be null");
    }

    @Override
    public Biotype biotype() {
        return this.metadata.biotype();
    }

    @Override
    public EvidenceLevel evidenceLevel() {
        return this.metadata.evidenceLevel();
    }

    @Override
    public Set<String> tags() {
        return this.metadata.tags();
    }

    @Override
    public Iterator<? extends GencodeTranscript> transcripts() {
        return this.transcripts.iterator();
    }

    public int transcriptCount() {
        return this.transcripts.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GencodeGeneImpl that = (GencodeGeneImpl)o;
        return Objects.equals(this.transcripts, that.transcripts) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.transcripts, this.metadata);
    }

    public String toString() {
        return "GencodeGeneImpl{id=" + String.valueOf(this.id) + ", location=" + String.valueOf(this.location) + ", transcripts=" + String.valueOf(this.transcripts) + ", gencodeMetadata=" + String.valueOf(this.metadata) + "}";
    }
}

