/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.gtf.model.impl.refseq;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.monarchinitiative.sgenes.gtf.model.Biotype;
import org.monarchinitiative.sgenes.gtf.model.RefseqGene;
import org.monarchinitiative.sgenes.gtf.model.RefseqTranscript;
import org.monarchinitiative.sgenes.model.GeneIdentifier;
import org.monarchinitiative.sgenes.model.base.BaseGene;
import org.monarchinitiative.svart.GenomicRegion;

public class RefseqGeneImpl
extends BaseGene
implements RefseqGene {
    private final List<? extends RefseqTranscript> transcripts;
    private final Biotype biotype;

    public static RefseqGeneImpl of(GeneIdentifier identifier, GenomicRegion location, List<? extends RefseqTranscript> transcripts, Biotype biotype) {
        return new RefseqGeneImpl(identifier, location, transcripts, biotype);
    }

    private RefseqGeneImpl(GeneIdentifier identifier, GenomicRegion location, List<? extends RefseqTranscript> transcripts, Biotype biotype) {
        super(identifier, location);
        this.transcripts = Objects.requireNonNull(transcripts, "Transcripts must not be null");
        if (this.transcripts.isEmpty()) {
            throw new IllegalArgumentException("Transcripts must not be empty");
        }
        this.biotype = Objects.requireNonNull(biotype, "Biotype must not be empty");
    }

    @Override
    public Iterator<? extends RefseqTranscript> transcripts() {
        return this.transcripts.iterator();
    }

    public int transcriptCount() {
        return this.transcripts.size();
    }

    @Override
    public Biotype biotype() {
        return this.biotype;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RefseqGeneImpl that = (RefseqGeneImpl)o;
        return Objects.equals(this.transcripts, that.transcripts) && Objects.equals((Object)this.biotype, (Object)that.biotype);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.transcripts, this.biotype});
    }

    public String toString() {
        return "RefseqGeneImpl{id=" + String.valueOf(this.id) + ", location=" + String.valueOf(this.location) + ", transcripts=" + String.valueOf(this.transcripts) + ", biotype=" + String.valueOf((Object)this.biotype) + "}";
    }
}

