/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.io.json;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.monarchinitiative.sgenes.io.GeneParser;
import org.monarchinitiative.sgenes.io.json.deserialize.CoordinateDeserializer;
import org.monarchinitiative.sgenes.io.json.deserialize.GeneDeserializer;
import org.monarchinitiative.sgenes.io.json.deserialize.GeneIdentifierDeserializer;
import org.monarchinitiative.sgenes.io.json.deserialize.GenomicRegionDeserializer;
import org.monarchinitiative.sgenes.io.json.deserialize.TranscriptDeserializer;
import org.monarchinitiative.sgenes.io.json.deserialize.TranscriptIdentifierDeserializer;
import org.monarchinitiative.sgenes.io.json.serialize.CoordinateSerializer;
import org.monarchinitiative.sgenes.io.json.serialize.GeneIdentifierSerializer;
import org.monarchinitiative.sgenes.io.json.serialize.GeneSerializer;
import org.monarchinitiative.sgenes.io.json.serialize.GenomicRegionSerializer;
import org.monarchinitiative.sgenes.io.json.serialize.TranscriptIdentifierSerializer;
import org.monarchinitiative.sgenes.io.json.serialize.TranscriptSerializer;
import org.monarchinitiative.sgenes.model.Gene;
import org.monarchinitiative.sgenes.model.GeneIdentifier;
import org.monarchinitiative.sgenes.model.Transcript;
import org.monarchinitiative.sgenes.model.TranscriptIdentifier;
import org.monarchinitiative.svart.CoordinateSystem;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;
import org.monarchinitiative.svart.assembly.GenomicAssembly;

public class JsonGeneParser
implements GeneParser {
    public static final CoordinateSystem CS = CoordinateSystem.zeroBased();
    private static final Version VERSION = new Version(0, 1, 0, null, null, null);
    private static final TypeReference<List<Gene>> TYPE_REFERENCE = new TypeReference<List<Gene>>(){};
    private final ObjectMapper objectMapper = new ObjectMapper();

    public static JsonGeneParser of(GenomicAssembly assembly) {
        return new JsonGeneParser(assembly);
    }

    private JsonGeneParser(GenomicAssembly assembly) {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.objectMapper.registerModule((Module)JsonGeneParser.prepareModule(assembly));
    }

    private static SimpleModule prepareModule(GenomicAssembly assembly) {
        SimpleModule module = new SimpleModule("JsonGeneSerializer", VERSION);
        module.addSerializer((JsonSerializer)new CoordinateSerializer());
        module.addSerializer((JsonSerializer)new GenomicRegionSerializer());
        module.addSerializer((JsonSerializer)new TranscriptIdentifierSerializer());
        module.addSerializer((JsonSerializer)new TranscriptSerializer());
        module.addSerializer((JsonSerializer)new GeneIdentifierSerializer());
        module.addSerializer((JsonSerializer)new GeneSerializer());
        module.addDeserializer(Coordinates.class, (JsonDeserializer)new CoordinateDeserializer());
        module.addDeserializer(Gene.class, (JsonDeserializer)new GeneDeserializer());
        module.addDeserializer(GeneIdentifier.class, (JsonDeserializer)new GeneIdentifierDeserializer());
        module.addDeserializer(GenomicRegion.class, (JsonDeserializer)new GenomicRegionDeserializer(assembly));
        module.addDeserializer(Transcript.class, (JsonDeserializer)new TranscriptDeserializer());
        module.addDeserializer(TranscriptIdentifier.class, (JsonDeserializer)new TranscriptIdentifierDeserializer());
        return module;
    }

    public List<Gene> read(InputStream inputStream) throws IOException {
        return (List)this.objectMapper.readValue(inputStream, TYPE_REFERENCE);
    }

    @Override
    public void write(List<? extends Gene> genes, OutputStream outputStream) throws IOException {
        this.objectMapper.writeValue(outputStream, genes);
    }
}

