/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.io.json.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.monarchinitiative.sgenes.io.json.JsonGeneParser;
import org.monarchinitiative.svart.Contig;
import org.monarchinitiative.svart.CoordinateSystem;
import org.monarchinitiative.svart.GenomicRegion;
import org.monarchinitiative.svart.Strand;
import org.monarchinitiative.svart.assembly.GenomicAssembly;

public class GenomicRegionDeserializer
extends StdDeserializer<GenomicRegion> {
    private static final long serialVersionUID = 1L;
    private final GenomicAssembly assembly;

    public GenomicRegionDeserializer(GenomicAssembly assembly) {
        this(GenomicRegion.class, assembly);
    }

    protected GenomicRegionDeserializer(Class<?> vc, GenomicAssembly assembly) {
        super(vc);
        this.assembly = assembly;
    }

    public GenomicRegion deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        Strand strand;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String accession = node.get("gbAccession").asText();
        Contig contig = this.assembly.contigByName(accession);
        if (contig.isUnknown()) {
            throw new IllegalArgumentException("Unknown contig `" + accession + "`");
        }
        switch (node.get("strand").asText()) {
            case "+": {
                strand = Strand.POSITIVE;
                break;
            }
            case "-": {
                strand = Strand.NEGATIVE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown strand `" + node.get("strand").asText() + "`");
            }
        }
        int start = node.get("start").asInt();
        int end = node.get("end").asInt();
        return GenomicRegion.of((Contig)contig, (Strand)strand, (CoordinateSystem)JsonGeneParser.CS, (int)start, (int)end);
    }
}

