/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.monarchinitiative.sgenes.model.Gene;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GeneParser {
    public static final Logger LOGGER = LoggerFactory.getLogger(GeneParser.class);

    private static InputStream openForReading(Path source) throws IOException {
        if (source.toFile().getName().endsWith(".gz")) {
            LOGGER.debug("Assuming the file is gzipped: `{}`", (Object)source.toAbsolutePath());
            return new BufferedInputStream(new GZIPInputStream(Files.newInputStream(source, new OpenOption[0])));
        }
        return Files.newInputStream(source, new OpenOption[0]);
    }

    private static OutputStream openForWriting(Path destination) throws IOException {
        if (destination.toFile().getName().endsWith(".gz")) {
            LOGGER.debug("Assuming the file is gzipped: `{}`", (Object)destination.toAbsolutePath());
            return new BufferedOutputStream(new GZIPOutputStream(Files.newOutputStream(destination, new OpenOption[0])));
        }
        return Files.newOutputStream(destination, new OpenOption[0]);
    }

    public void write(Iterable<? extends Gene> var1, OutputStream var2) throws IOException;

    default public void write(Iterable<? extends Gene> genes, Path destination) throws IOException {
        try (OutputStream outputStream = GeneParser.openForWriting(destination);){
            this.write(genes, outputStream);
        }
    }

    public List<? extends Gene> read(InputStream var1) throws IOException;

    default public List<? extends Gene> read(Path source) throws IOException {
        try (InputStream inputStream = GeneParser.openForReading(source);){
            List<? extends Gene> list = this.read(inputStream);
            return list;
        }
    }
}

