/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.io;

import org.monarchinitiative.sgenes.io.GeneParser;
import org.monarchinitiative.sgenes.io.SerializationFormat;
import org.monarchinitiative.sgenes.io.json.JsonGeneParser;
import org.monarchinitiative.svart.assembly.GenomicAssembly;

public class GeneParserFactory {
    private final JsonGeneParser jsonGeneParser;

    private GeneParserFactory(GenomicAssembly assembly) {
        this.jsonGeneParser = JsonGeneParser.of(assembly);
    }

    public static GeneParserFactory of(GenomicAssembly assembly) {
        return new GeneParserFactory(assembly);
    }

    public GeneParser forFormat(SerializationFormat format) {
        switch (format) {
            case JSON: {
                return this.jsonGeneParser;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown serialization format: %s", new Object[]{format}));
    }
}

