/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.io.json.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.monarchinitiative.sgenes.model.Gene;
import org.monarchinitiative.sgenes.model.GeneIdentifier;
import org.monarchinitiative.sgenes.model.Transcript;
import org.monarchinitiative.svart.GenomicRegion;

public class GeneDeserializer
extends StdDeserializer<Gene> {
    private static final long serialVersionUID = 1L;

    public GeneDeserializer() {
        this(Gene.class);
    }

    protected GeneDeserializer(Class<?> vc) {
        super(vc);
    }

    public Gene deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec codec = jp.getCodec();
        JsonNode node = (JsonNode)codec.readTree(jp);
        GeneIdentifier id = (GeneIdentifier)codec.treeToValue((TreeNode)node.get("id"), GeneIdentifier.class);
        GenomicRegion location = (GenomicRegion)codec.treeToValue((TreeNode)node.get("loc"), GenomicRegion.class);
        Iterator transcriptIterator = node.get("transcripts").elements();
        LinkedList<Transcript> transcripts = new LinkedList<Transcript>();
        while (transcriptIterator.hasNext()) {
            transcripts.add((Transcript)codec.treeToValue((TreeNode)transcriptIterator.next(), Transcript.class));
        }
        return Gene.of((GeneIdentifier)id, (GenomicRegion)location, transcripts);
    }
}

