/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.io.json.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.monarchinitiative.sgenes.model.Transcript;
import org.monarchinitiative.sgenes.model.TranscriptIdentifier;
import org.monarchinitiative.sgenes.model.TranscriptMetadata;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;

public class TranscriptDeserializer
extends StdDeserializer<Transcript> {
    private static final long serialVersionUID = 1L;

    public TranscriptDeserializer() {
        this(Transcript.class);
    }

    protected TranscriptDeserializer(Class<?> vc) {
        super(vc);
    }

    public Transcript deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec codec = jp.getCodec();
        JsonNode node = (JsonNode)codec.readTree(jp);
        TranscriptIdentifier id = (TranscriptIdentifier)codec.treeToValue((TreeNode)node.get("id"), TranscriptIdentifier.class);
        TranscriptMetadata metadata = (TranscriptMetadata)codec.treeToValue((TreeNode)node.get("metadata"), TranscriptMetadata.class);
        GenomicRegion location = (GenomicRegion)codec.treeToValue((TreeNode)node.get("loc"), GenomicRegion.class);
        Iterator exonIterator = node.get("exons").elements();
        LinkedList<Coordinates> exons = new LinkedList<Coordinates>();
        while (exonIterator.hasNext()) {
            exons.add((Coordinates)codec.treeToValue((TreeNode)exonIterator.next(), Coordinates.class));
        }
        Coordinates cdsCoordinates = null;
        if (node.hasNonNull("cdsCoordinates")) {
            cdsCoordinates = (Coordinates)codec.treeToValue((TreeNode)node.get("cdsCoordinates"), Coordinates.class);
        }
        return Transcript.of((TranscriptIdentifier)id, (GenomicRegion)location, exons, cdsCoordinates, (TranscriptMetadata)metadata);
    }
}

