/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.model.base;

import java.util.List;
import java.util.Objects;
import org.monarchinitiative.sgenes.model.Transcript;
import org.monarchinitiative.sgenes.model.TranscriptIdentifier;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;

public abstract class BaseTranscript
implements Transcript {
    private final TranscriptIdentifier id;
    private final GenomicRegion location;
    private final List<Coordinates> exons;

    protected BaseTranscript(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons) {
        this.id = Objects.requireNonNull(id, "ID must not be null");
        this.location = Objects.requireNonNull(location, "Location must not be null");
        this.exons = Objects.requireNonNull(exons, "Exons must not be null");
        if (exons.isEmpty()) {
            throw new IllegalArgumentException("Exon list must not be empty");
        }
    }

    @Override
    public TranscriptIdentifier id() {
        return this.id;
    }

    @Override
    public GenomicRegion location() {
        return this.location;
    }

    @Override
    public List<Coordinates> exons() {
        return this.exons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseTranscript that = (BaseTranscript)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.location, that.location) && Objects.equals(this.exons, that.exons);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.location, this.exons);
    }

    public String toString() {
        return "BaseTranscript{id=" + this.id + ", location=" + this.location + ", exons=" + this.exons + "}";
    }
}

