/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.monarchinitiative.sgenes.model.Annotated;
import org.monarchinitiative.sgenes.model.CodingTranscript;
import org.monarchinitiative.sgenes.model.Identified;
import org.monarchinitiative.sgenes.model.Located;
import org.monarchinitiative.sgenes.model.TranscriptIdentifier;
import org.monarchinitiative.sgenes.model.TranscriptMetadata;
import org.monarchinitiative.sgenes.model.impl.CodingTranscriptDefault;
import org.monarchinitiative.sgenes.model.impl.TranscriptDefault;
import org.monarchinitiative.svart.CoordinateSystem;
import org.monarchinitiative.svart.Coordinates;
import org.monarchinitiative.svart.GenomicRegion;

public interface Transcript
extends Located,
Identified<TranscriptIdentifier>,
Annotated<TranscriptMetadata> {
    public static Transcript of(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons, Coordinates cdsCoordinates, TranscriptMetadata metadata) {
        Objects.requireNonNull(exons, "Exons must not be null");
        if (exons.isEmpty()) {
            throw new IllegalArgumentException("Exon list must not be empty");
        }
        if (cdsCoordinates == null) {
            return TranscriptDefault.of(id, location, exons, metadata);
        }
        return CodingTranscriptDefault.of(id, location, exons, cdsCoordinates, metadata);
    }

    @Deprecated(since="0.2.1", forRemoval=true)
    public static Transcript noncoding(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons) {
        return Transcript.of(id, location, exons, null, TranscriptMetadata.of(null));
    }

    @Deprecated(since="0.2.1", forRemoval=true)
    public static CodingTranscript coding(TranscriptIdentifier id, GenomicRegion location, List<Coordinates> exons, Coordinates cdsCoordinates) {
        return (CodingTranscript)Transcript.of(id, location, exons, cdsCoordinates, TranscriptMetadata.of(null));
    }

    private static List<Coordinates> computeIntronLocations(List<Coordinates> exons) {
        if (exons.size() == 1) {
            return List.of();
        }
        ArrayList<Coordinates> introns = new ArrayList<Coordinates>(exons.size() - 1);
        int intronStart = exons.get(0).endWithCoordinateSystem(CoordinateSystem.zeroBased());
        for (int i = 1; i < exons.size(); ++i) {
            Coordinates exon = exons.get(i);
            int intronEnd = exon.startWithCoordinateSystem(CoordinateSystem.zeroBased());
            introns.add(Coordinates.of((CoordinateSystem)exon.coordinateSystem(), (int)intronStart, (int)intronEnd));
            intronStart = exon.endWithCoordinateSystem(CoordinateSystem.zeroBased());
        }
        return List.copyOf(introns);
    }

    public List<Coordinates> exons();

    default public int exonCount() {
        return this.exons().size();
    }

    default public List<Coordinates> introns() {
        return Transcript.computeIntronLocations(this.exons());
    }

    default public int intronCount() {
        return this.exons().size() - 1;
    }

    default public boolean isCoding() {
        return this instanceof CodingTranscript;
    }
}

