/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.sgenes.model.impl;

import java.util.Objects;
import java.util.Optional;
import org.monarchinitiative.sgenes.model.GeneIdentifier;
import org.monarchinitiative.sgenes.model.impl.IdentifierDefault;

public class GeneIdentifierDefault
extends IdentifierDefault
implements GeneIdentifier {
    private final String hgncId;
    private final String ncbiGeneId;

    public GeneIdentifierDefault(String accession, String symbol, String hgncId, String ncbiGeneId) {
        super(accession, symbol);
        this.hgncId = hgncId;
        this.ncbiGeneId = ncbiGeneId;
    }

    @Override
    public Optional<String> hgncId() {
        return Optional.ofNullable(this.hgncId);
    }

    @Override
    public Optional<String> ncbiGeneId() {
        return Optional.ofNullable(this.ncbiGeneId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeneIdentifierDefault that = (GeneIdentifierDefault)o;
        return Objects.equals(this.hgncId, that.hgncId) && Objects.equals(this.ncbiGeneId, that.ncbiGeneId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hgncId, this.ncbiGeneId);
    }

    @Override
    public String toString() {
        return "GeneIdentifierDefault{accession='" + this.accession() + "', symbol='" + this.symbol() + "', hgncId='" + this.hgncId + "', ncbiGeneId='" + this.ncbiGeneId + "'}";
    }
}

