/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import com.mongodb.DBRefBase;
import com.mongodb.util.MyAsserts;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.OutputBuffer;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

public class BasicBSONEncoder
implements BSONEncoder {
    static final boolean DEBUG = false;
    protected OutputBuffer _buf;

    public byte[] encode(BSONObject o) {
        BasicOutputBuffer buf = new BasicOutputBuffer();
        this.set(buf);
        this.putObject(o);
        this.done();
        return buf.toByteArray();
    }

    public void set(OutputBuffer out) {
        if (this._buf != null) {
            throw new IllegalStateException("in the middle of something");
        }
        this._buf = out;
    }

    public void done() {
        this._buf = null;
    }

    protected boolean handleSpecialObjects(String name, BSONObject o) {
        return false;
    }

    protected boolean putSpecial(String name, Object o) {
        return false;
    }

    public int putObject(BSONObject o) {
        return this.putObject(null, o);
    }

    protected int putObject(String name, BSONObject o) {
        boolean rewriteID;
        if (o == null) {
            throw new NullPointerException("can't save a null object");
        }
        int start = this._buf.getPosition();
        byte myType = 3;
        if (o instanceof List) {
            myType = 4;
        }
        if (this.handleSpecialObjects(name, o)) {
            return this._buf.getPosition() - start;
        }
        if (name != null) {
            this._put(myType, name);
        }
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        List transientFields = null;
        boolean bl = rewriteID = myType == 3 && name == null;
        if (myType == 3) {
            Object temp;
            if (rewriteID && o.containsField("_id")) {
                this._putObjectField("_id", o.get("_id"));
            }
            if ((temp = o.get("_transientFields")) instanceof List) {
                transientFields = (List)temp;
            }
        }
        if (o instanceof Map) {
            for (Map.Entry entry : ((Map)((Object)o)).entrySet()) {
                if (rewriteID && ((String)entry.getKey()).equals("_id") || transientFields != null && transientFields.contains(entry.getKey())) continue;
                this._putObjectField((String)entry.getKey(), entry.getValue());
            }
        } else {
            for (String string : o.keySet()) {
                if (rewriteID && string.equals("_id") || transientFields != null && transientFields.contains(string)) continue;
                Object val = o.get(string);
                this._putObjectField(string, val);
            }
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
        return this._buf.getPosition() - start;
    }

    protected void _putObjectField(String name, Object val) {
        if (name.equals("_transientFields")) {
            return;
        }
        if (name.equals("$where") && val instanceof String) {
            this._put((byte)13, name);
            this._putValueString(val.toString());
            return;
        }
        if ((val = BSON.applyEncodingHooks(val)) == null) {
            this.putNull(name);
        } else if (val instanceof Date) {
            this.putDate(name, (Date)val);
        } else if (val instanceof Number) {
            this.putNumber(name, (Number)val);
        } else if (val instanceof Character) {
            this.putString(name, val.toString());
        } else if (val instanceof String) {
            this.putString(name, val.toString());
        } else if (val instanceof ObjectId) {
            this.putObjectId(name, (ObjectId)val);
        } else if (val instanceof BSONObject) {
            this.putObject(name, (BSONObject)val);
        } else if (val instanceof Boolean) {
            this.putBoolean(name, (Boolean)val);
        } else if (val instanceof Pattern) {
            this.putPattern(name, (Pattern)val);
        } else if (val instanceof Map) {
            this.putMap(name, (Map)val);
        } else if (val instanceof Iterable) {
            this.putIterable(name, (Iterable)val);
        } else if (val instanceof byte[]) {
            this.putBinary(name, (byte[])val);
        } else if (val instanceof Binary) {
            this.putBinary(name, (Binary)val);
        } else if (val instanceof UUID) {
            this.putUUID(name, (UUID)val);
        } else if (val.getClass().isArray()) {
            this.putArray(name, val);
        } else if (val instanceof Symbol) {
            this.putSymbol(name, (Symbol)val);
        } else if (val instanceof BSONTimestamp) {
            this.putTimestamp(name, (BSONTimestamp)val);
        } else if (val instanceof CodeWScope) {
            this.putCodeWScope(name, (CodeWScope)val);
        } else if (val instanceof Code) {
            this.putCode(name, (Code)val);
        } else if (val instanceof DBRefBase) {
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$ref", (Object)((DBRefBase)val).getRef());
            temp.put("$id", ((DBRefBase)val).getId());
            this.putObject(name, temp);
        } else if (val instanceof MinKey) {
            this.putMinKey(name);
        } else if (val instanceof MaxKey) {
            this.putMaxKey(name);
        } else if (!this.putSpecial(name, val)) {
            throw new IllegalArgumentException("can't serialize " + val.getClass());
        }
    }

    private void putArray(String name, Object array) {
        this._put((byte)4, name);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        int size = Array.getLength(array);
        for (int i = 0; i < size; ++i) {
            this._putObjectField(String.valueOf(i), Array.get(array, i));
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    private void putIterable(String name, Iterable l) {
        this._put((byte)4, name);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        int i = 0;
        for (Object obj : l) {
            this._putObjectField(String.valueOf(i), obj);
            ++i;
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    private void putMap(String name, Map m) {
        this._put((byte)3, name);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        for (Map.Entry entry : m.entrySet()) {
            this._putObjectField(entry.getKey().toString(), entry.getValue());
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    protected void putNull(String name) {
        this._put((byte)10, name);
    }

    protected void putUndefined(String name) {
        this._put((byte)6, name);
    }

    protected void putTimestamp(String name, BSONTimestamp ts) {
        this._put((byte)17, name);
        this._buf.writeInt(ts.getInc());
        this._buf.writeInt(ts.getTime());
    }

    protected void putCodeWScope(String name, CodeWScope code) {
        this._put((byte)15, name);
        int temp = this._buf.getPosition();
        this._buf.writeInt(0);
        this._putValueString(code.getCode());
        this.putObject(code.getScope());
        this._buf.writeInt(temp, this._buf.getPosition() - temp);
    }

    protected void putCode(String name, Code code) {
        this._put((byte)13, name);
        int temp = this._buf.getPosition();
        this._putValueString(code.getCode());
    }

    protected void putBoolean(String name, Boolean b) {
        this._put((byte)8, name);
        this._buf.write(b != false ? 1 : 0);
    }

    protected void putDate(String name, Date d) {
        this._put((byte)9, name);
        this._buf.writeLong(d.getTime());
    }

    protected void putNumber(String name, Number n) {
        if (n instanceof Integer || n instanceof Short || n instanceof Byte || n instanceof AtomicInteger) {
            this._put((byte)16, name);
            this._buf.writeInt(n.intValue());
        } else if (n instanceof Long || n instanceof AtomicLong) {
            this._put((byte)18, name);
            this._buf.writeLong(n.longValue());
        } else if (n instanceof Float || n instanceof Double) {
            this._put((byte)1, name);
            this._buf.writeDouble(n.doubleValue());
        } else {
            throw new IllegalArgumentException("can't serialize " + n.getClass());
        }
    }

    protected void putBinary(String name, byte[] data) {
        this.putBinary(name, 0, data);
    }

    protected void putBinary(String name, Binary val) {
        this.putBinary(name, val.getType(), val.getData());
    }

    private void putBinary(String name, int type, byte[] data) {
        this._put((byte)5, name);
        int totalLen = data.length;
        if (type == 2) {
            totalLen += 4;
        }
        this._buf.writeInt(totalLen);
        this._buf.write(type);
        if (type == 2) {
            this._buf.writeInt(totalLen - 4);
        }
        int before = this._buf.getPosition();
        this._buf.write(data);
        int after = this._buf.getPosition();
        MyAsserts.assertEquals((int)(after - before), (int)data.length);
    }

    protected void putUUID(String name, UUID val) {
        this._put((byte)5, name);
        this._buf.writeInt(16);
        this._buf.write(3);
        this._buf.writeLong(val.getMostSignificantBits());
        this._buf.writeLong(val.getLeastSignificantBits());
    }

    protected void putSymbol(String name, Symbol s) {
        this._putString(name, s.getSymbol(), (byte)14);
    }

    protected void putString(String name, String s) {
        this._putString(name, s, (byte)2);
    }

    private void _putString(String name, String s, byte type) {
        this._put(type, name);
        this._putValueString(s);
    }

    protected void putObjectId(String name, ObjectId oid) {
        this._put((byte)7, name);
        this._buf.writeIntBE(oid._time());
        this._buf.writeIntBE(oid._machine());
        this._buf.writeIntBE(oid._inc());
    }

    private void putPattern(String name, Pattern p) {
        this._put((byte)11, name);
        this._put(p.pattern());
        this._put(BSON.regexFlags(p.flags()));
    }

    private void putMinKey(String name) {
        this._put((byte)-1, name);
    }

    private void putMaxKey(String name) {
        this._put((byte)127, name);
    }

    protected void _put(byte type, String name) {
        this._buf.write(type);
        this._put(name);
    }

    protected void _putValueString(String s) {
        int lenPos = this._buf.getPosition();
        this._buf.writeInt(0);
        int strLen = this._put(s);
        this._buf.writeInt(lenPos, strLen);
    }

    void _reset(Buffer b) {
        b.position(0);
        b.limit(b.capacity());
    }

    protected int _put(String str) {
        int c;
        int len = str.length();
        int total = 0;
        for (int i = 0; i < len; i += Character.charCount(c)) {
            c = Character.codePointAt(str, i);
            if (c < 128) {
                this._buf.write((byte)c);
                ++total;
                continue;
            }
            if (c < 2048) {
                this._buf.write((byte)(192 + (c >> 6)));
                this._buf.write((byte)(128 + (c & 0x3F)));
                total += 2;
                continue;
            }
            if (c < 65536) {
                this._buf.write((byte)(224 + (c >> 12)));
                this._buf.write((byte)(128 + (c >> 6 & 0x3F)));
                this._buf.write((byte)(128 + (c & 0x3F)));
                total += 3;
                continue;
            }
            this._buf.write((byte)(240 + (c >> 18)));
            this._buf.write((byte)(128 + (c >> 12 & 0x3F)));
            this._buf.write((byte)(128 + (c >> 6 & 0x3F)));
            this._buf.write((byte)(128 + (c & 0x3F)));
            total += 4;
        }
        this._buf.write(0);
        return ++total;
    }

    public void writeInt(int x) {
        this._buf.writeInt(x);
    }

    public void writeLong(long x) {
        this._buf.writeLong(x);
    }

    public void writeCString(String s) {
        this._put(s);
    }
}

