/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import org.bson.BsonWriterSettings;
import org.bson.json.JsonMode;

public class JsonWriterSettings
extends BsonWriterSettings {
    private final boolean indent;
    private final String newLineCharacters;
    private final String indentCharacters;
    private final JsonMode outputMode;

    public JsonWriterSettings() {
        this(JsonMode.STRICT, false, null, null);
    }

    public JsonWriterSettings(JsonMode outputMode) {
        this(outputMode, false, null, null);
    }

    public JsonWriterSettings(boolean indent) {
        this(JsonMode.STRICT, true, "  ", null);
    }

    public JsonWriterSettings(JsonMode outputMode, boolean indent) {
        this(outputMode, true, "  ", null);
    }

    public JsonWriterSettings(JsonMode outputMode, String indentCharacters) {
        this(outputMode, true, indentCharacters, null);
    }

    public JsonWriterSettings(JsonMode outputMode, String indentCharacters, String newLineCharacters) {
        this(outputMode, true, indentCharacters, newLineCharacters);
    }

    private JsonWriterSettings(JsonMode outputMode, boolean indent, String indentCharacters, String newLineCharacters) {
        if (indent) {
            if (indentCharacters == null) {
                throw new IllegalArgumentException("indent characters can not be null if indent is enabled");
            }
        } else {
            if (newLineCharacters != null) {
                throw new IllegalArgumentException("new line characters can not be null if indent is disabled.");
            }
            if (indentCharacters != null) {
                throw new IllegalArgumentException("indent characters can not be null if indent is disabled.");
            }
        }
        if (outputMode == null) {
            throw new IllegalArgumentException("output mode can not be null");
        }
        this.indent = indent;
        this.newLineCharacters = newLineCharacters != null ? newLineCharacters : System.getProperty("line.separator");
        this.indentCharacters = indentCharacters;
        this.outputMode = outputMode;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public String getNewLineCharacters() {
        return this.newLineCharacters;
    }

    public String getIndentCharacters() {
        return this.indentCharacters;
    }

    public JsonMode getOutputMode() {
        return this.outputMode;
    }
}

