/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Float32Vector;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

final class Float32VectorCodec
implements Codec<Float32Vector> {
    Float32VectorCodec() {
    }

    @Override
    public void encode(BsonWriter writer, Float32Vector vectorToEncode, EncoderContext encoderContext) {
        writer.writeBinaryData(new BsonBinary(vectorToEncode));
    }

    @Override
    public Float32Vector decode(BsonReader reader, DecoderContext decoderContext) {
        byte subType = reader.peekBinarySubType();
        if (subType != BsonBinarySubType.VECTOR.getValue()) {
            throw new BsonInvalidOperationException("Expected vector binary subtype " + BsonBinarySubType.VECTOR.getValue() + " but found: " + subType);
        }
        return reader.readBinaryData().asBinary().asVector().asFloat32Vector();
    }

    @Override
    public Class<Float32Vector> getEncoderClass() {
        return Float32Vector.class;
    }
}

