/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.statistics;

import com.mongodb.annotations.ThreadSafe;
import com.mongodb.kafka.connect.source.statistics.StatisticsManager;
import com.mongodb.kafka.connect.util.jmx.SourceTaskStatistics;
import com.mongodb.kafka.connect.util.jmx.internal.CombinedMongoMBean;
import com.mongodb.kafka.connect.util.jmx.internal.MBeanServerUtils;
import java.util.Map;
import javax.management.ObjectName;

@ThreadSafe
public final class JmxStatisticsManager
implements StatisticsManager {
    private static final String COPY_BEAN = "source-task-copy-existing";
    private static final String STREAM_BEAN = "source-task-change-stream";
    private static final String COMBINED_BEAN = "source-task";
    private final SourceTaskStatistics copyStatistics;
    private final SourceTaskStatistics streamStatistics;
    private final CombinedMongoMBean combinedStatistics;
    private volatile SourceTaskStatistics currentStatistics;

    public JmxStatisticsManager(boolean startWithCopyStatistics, String connectorName) {
        this.copyStatistics = new SourceTaskStatistics(JmxStatisticsManager.getMBeanName(COPY_BEAN, connectorName));
        this.streamStatistics = new SourceTaskStatistics(JmxStatisticsManager.getMBeanName(STREAM_BEAN, connectorName));
        this.combinedStatistics = new CombinedMongoMBean(JmxStatisticsManager.getMBeanName(COMBINED_BEAN, connectorName), this.copyStatistics, this.streamStatistics);
        this.currentStatistics = startWithCopyStatistics ? this.copyStatistics : this.streamStatistics;
        this.copyStatistics.register();
        this.streamStatistics.register();
        this.combinedStatistics.register();
    }

    @Override
    public SourceTaskStatistics currentStatistics() {
        return this.currentStatistics;
    }

    @Override
    public void switchToStreamStatistics() {
        this.currentStatistics = this.streamStatistics;
    }

    @Override
    public void close() {
        this.copyStatistics.unregister();
        this.streamStatistics.unregister();
        this.combinedStatistics.unregister();
    }

    private static String getMBeanName(String mBean, String connectorName) {
        String id = MBeanServerUtils.taskIdFromCurrentThread();
        return "com.mongodb.kafka.connect:type=source-task-metrics,connector=" + connectorName + ",task=" + mBean + "-" + id;
    }

    public static String getConnectorName(Map<String, String> props) {
        String originalName = props.getOrDefault("name", "unknown");
        String quotedName = ObjectName.quote(originalName);
        if (quotedName.substring(1, quotedName.length() - 1).equals(originalName)) {
            return originalName;
        }
        return quotedName;
    }
}

