/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import java.util.OptionalLong;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;

public final class ResumeTokenUtils {
    private ResumeTokenUtils() {
    }

    public static BsonTimestamp getTimestampFromResumeToken(BsonDocument resumeToken) {
        byte[] bytes;
        if (!resumeToken.containsKey((Object)"_data")) {
            throw new IllegalArgumentException("Expected _data field in resume token");
        }
        BsonValue data = resumeToken.get((Object)"_data");
        if (data.isString()) {
            String hexString = data.asString().getValue();
            bytes = ResumeTokenUtils.parseHex(hexString);
        } else if (data.isBinary()) {
            bytes = data.asBinary().getData();
        } else {
            throw new IllegalArgumentException("Expected binary or string for _data field in resume token but found " + data.getBsonType());
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
        int canonicalType = byteBuffer.get() & 0xFF;
        if (canonicalType != 130) {
            throw new IllegalArgumentException("Expected canonical type equal to 130, but found " + canonicalType);
        }
        long timestampAsLong = byteBuffer.asLongBuffer().get();
        return new BsonTimestamp(timestampAsLong);
    }

    public static byte[] parseHex(String hexString) {
        byte[] bytes = new byte[hexString.length() / 2];
        int i = 0;
        int ii = 0;
        while (i < bytes.length) {
            int high = Character.digit(hexString.charAt(ii), 16);
            int low = Character.digit(hexString.charAt(ii + 1), 16);
            bytes[i] = (byte)(high << 4 | low);
            ++i;
            ii += 2;
        }
        return bytes;
    }

    public static OptionalLong getResponseOffsetSecs(BsonDocument response) {
        return Optional.of(response).map(v -> v.get((Object)"cursor")).map(BsonValue::asDocument).map(v -> v.get((Object)"postBatchResumeToken")).map(BsonValue::asDocument).map(token -> response.get((Object)"operationTime").asTimestamp().getTime() - ResumeTokenUtils.getTimestampFromResumeToken(token).asTimestamp().getTime()).map(OptionalLong::of).orElse(OptionalLong.empty());
    }
}

