/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink;

import com.mongodb.ConnectionString;
import com.mongodb.kafka.connect.sink.MongoSinkTask;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.SinkConfigSoftValidator;
import com.mongodb.kafka.connect.util.ServerApiConfig;
import com.mongodb.kafka.connect.util.SslConfigs;
import com.mongodb.kafka.connect.util.Validators;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.slf4j.Logger;

public class MongoSinkConfig
extends AbstractConfig {
    private static final String EMPTY_STRING = "";
    public static final String TOPICS_CONFIG = "topics";
    private static final String TOPICS_DOC = "A list of kafka topics for the sink connector, separated by commas";
    public static final String TOPICS_DEFAULT = "";
    private static final String TOPICS_DISPLAY = "The Kafka topics";
    public static final String TOPICS_REGEX_CONFIG = "topics.regex";
    private static final String TOPICS_REGEX_DOC = "Regular expression giving topics to consume. Under the hood, the regex is compiled to a <code>java.util.regex.Pattern</code>. Only one of topics or topics.regex should be specified.";
    private static final String TOPICS_REGEX_DEFAULT = "";
    private static final String TOPICS_REGEX_DISPLAY = "Topics regex";
    public static final String CONNECTION_URI_CONFIG = "connection.uri";
    private static final String CONNECTION_URI_DEFAULT = "mongodb://localhost:27017";
    private static final String CONNECTION_URI_DISPLAY = "MongoDB Connection URI";
    private static final String CONNECTION_URI_DOC = "The connection URI as supported by the official drivers. eg: ``mongodb://user@pass@locahost/``.";
    public static final String TOPIC_OVERRIDE_CONFIG = "topic.override.%s.%s";
    private static final String TOPIC_OVERRIDE_DEFAULT = "";
    private static final String TOPIC_OVERRIDE_DISPLAY = "Per topic configuration overrides.";
    public static final String TOPIC_OVERRIDE_DOC = "The overrides configuration allows for per topic customization of configuration. The customized overrides are merged with the default configuration, to create the specific configuration for a topic.\nFor example, ``topic.override.foo.collection=bar`` will store data from the ``foo`` topic into the ``bar`` collection.\nNote: All configuration options apart from 'connection.uri' and 'topics' are overridable.";
    static final String PROVIDER_CONFIG = "provider";
    private static final List<String> INVISIBLE_CONFIGS = Collections.singletonList("topic.override.%s.%s");
    private Map<String, String> originals;
    private final Optional<List<String>> topics;
    private final Optional<Pattern> topicsRegex;
    private Map<String, MongoSinkTopicConfig> topicSinkConnectorConfigMap;
    private ConnectionString connectionString;
    public static final ConfigDef CONFIG = MongoSinkConfig.createConfigDef();

    public MongoSinkConfig(Map<String, String> originals) {
        super(CONFIG, originals, false);
        this.originals = Collections.unmodifiableMap(originals);
        this.topics = this.getList(TOPICS_CONFIG).isEmpty() ? Optional.empty() : Optional.of(Collections.unmodifiableList(this.getList(TOPICS_CONFIG)));
        Optional<Object> optional = this.topicsRegex = this.getString(TOPICS_REGEX_CONFIG).isEmpty() ? Optional.empty() : Optional.of(Pattern.compile(this.getString(TOPICS_REGEX_CONFIG)));
        if (this.topics.isPresent() && this.topicsRegex.isPresent()) {
            throw new ConfigException(String.format("%s and %s are mutually exclusive options, but both are set.", TOPICS_CONFIG, TOPICS_REGEX_CONFIG));
        }
        if (!this.topics.isPresent() && !this.topicsRegex.isPresent()) {
            throw new ConfigException(String.format("Must configure one of %s or %s", TOPICS_CONFIG, TOPICS_REGEX_CONFIG));
        }
        this.connectionString = new ConnectionString(this.getPassword(CONNECTION_URI_CONFIG).value());
        this.topicSinkConnectorConfigMap = new ConcurrentHashMap<String, MongoSinkTopicConfig>(this.topics.orElse(Collections.emptyList()).stream().collect(Collectors.toMap(t -> t, t -> new MongoSinkTopicConfig((String)t, originals))));
        if (this.topicsRegex.isPresent()) {
            Pattern topicRegex = this.topicsRegex.get();
            originals.keySet().stream().filter(k -> k.startsWith("topic.override.")).forEach(k -> {
                String topic = k.substring("topic.override.".length()).split("\\.")[0];
                if (!this.topicSinkConnectorConfigMap.containsKey(topic) && topicRegex.matcher(topic).matches()) {
                    this.topicSinkConnectorConfigMap.put(topic, new MongoSinkTopicConfig(topic, originals));
                }
            });
        }
    }

    static String createOverrideKey(String topic, String config) {
        if (!CONFIG.configKeys().containsKey(config)) {
            throw new ConfigException("Unknown configuration key: " + config);
        }
        return String.format(TOPIC_OVERRIDE_CONFIG, topic, config);
    }

    public ConnectionString getConnectionString() {
        return this.connectionString;
    }

    public Optional<List<String>> getTopics() {
        return this.topics;
    }

    public Optional<Pattern> getTopicRegex() {
        return this.topicsRegex;
    }

    public Map<String, String> getOriginals() {
        return this.originals;
    }

    public MongoSinkTopicConfig getMongoSinkTopicConfig(String topic) {
        if (!this.topicSinkConnectorConfigMap.containsKey(topic)) {
            this.topics.ifPresent(topicsList -> {
                if (!topicsList.contains(topic)) {
                    throw new ConfigException(String.format("Unknown topic: %s, must be one of: %s", topic, topicsList));
                }
            });
            this.topicsRegex.ifPresent(topicRegex -> {
                if (!topicRegex.matcher(topic).matches()) {
                    throw new ConfigException(String.format("Unknown topic: %s, does not match: %s", topic, topicRegex));
                }
                if (!this.topicSinkConnectorConfigMap.containsKey(topic)) {
                    this.topicSinkConnectorConfigMap.put(topic, new MongoSinkTopicConfig(topic, this.originals));
                }
            });
        }
        return this.topicSinkConnectorConfigMap.get(topic);
    }

    private static ConfigDef createConfigDef() {
        ConfigDef configDef = new ConfigDef(){

            public Map<String, ConfigValue> validateAll(Map<String, String> props) {
                boolean hasTopicsRegexConfig;
                SinkConfigSoftValidator.logObsoleteProperties(props.keySet(), arg_0 -> ((Logger)MongoSinkTask.LOGGER).warn(arg_0));
                SinkConfigSoftValidator.logIncompatibleProperties(props, arg_0 -> ((Logger)MongoSinkTask.LOGGER).warn(arg_0));
                Map results = super.validateAll(props);
                INVISIBLE_CONFIGS.forEach(c -> {
                    if (results.containsKey(c)) {
                        ((ConfigValue)results.get(c)).visible(false);
                    }
                });
                if (results.values().stream().anyMatch(c -> !c.errorMessages().isEmpty())) {
                    return results;
                }
                boolean hasTopicsConfig = !props.getOrDefault(MongoSinkConfig.TOPICS_CONFIG, "").trim().isEmpty();
                boolean bl = hasTopicsRegexConfig = !props.getOrDefault(MongoSinkConfig.TOPICS_REGEX_CONFIG, "").trim().isEmpty();
                if (hasTopicsConfig && hasTopicsRegexConfig) {
                    ((ConfigValue)results.get(MongoSinkConfig.TOPICS_CONFIG)).addErrorMessage(String.format("%s and %s are mutually exclusive options, but both are set.", MongoSinkConfig.TOPICS_CONFIG, MongoSinkConfig.TOPICS_REGEX_CONFIG));
                } else if (!hasTopicsConfig && !hasTopicsRegexConfig) {
                    ((ConfigValue)results.get(MongoSinkConfig.TOPICS_CONFIG)).addErrorMessage(String.format("Must configure one of %s or %s", MongoSinkConfig.TOPICS_CONFIG, MongoSinkConfig.TOPICS_REGEX_CONFIG));
                }
                if (hasTopicsConfig) {
                    List topics = (List)((ConfigValue)results.get(MongoSinkConfig.TOPICS_CONFIG)).value();
                    topics.forEach(topic -> results.putAll(MongoSinkTopicConfig.validateAll(topic, props)));
                } else if (hasTopicsRegexConfig) {
                    results.putAll(MongoSinkTopicConfig.validateRegexAll(props));
                }
                return results;
            }
        };
        String group = "Connection";
        int orderInGroup = 0;
        configDef.define(TOPICS_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.HIGH, TOPICS_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TOPICS_DISPLAY);
        configDef.define(TOPICS_REGEX_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)Validators.isAValidRegex(), ConfigDef.Importance.HIGH, TOPICS_REGEX_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TOPICS_REGEX_DISPLAY);
        configDef.define(CONNECTION_URI_CONFIG, ConfigDef.Type.PASSWORD, (Object)CONNECTION_URI_DEFAULT, (ConfigDef.Validator)Validators.errorCheckingPasswordValueValidator("A valid connection string", ConnectionString::new), ConfigDef.Importance.HIGH, CONNECTION_URI_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, CONNECTION_URI_DISPLAY);
        ServerApiConfig.addServerApiConfig(configDef);
        SslConfigs.addSslConfigDef(configDef);
        group = "Overrides";
        orderInGroup = 0;
        configDef.define(TOPIC_OVERRIDE_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)Validators.topicOverrideValidator(), ConfigDef.Importance.LOW, TOPIC_OVERRIDE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TOPIC_OVERRIDE_DISPLAY);
        configDef.defineInternal(PROVIDER_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW);
        MongoSinkTopicConfig.BASE_CONFIG.configKeys().values().forEach(arg_0 -> ((ConfigDef)configDef).define(arg_0));
        return configDef;
    }
}

