/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.id.strategy;

import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.id.strategy.IdStrategy;
import java.util.Optional;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonNull;
import org.bson.BsonValue;

abstract class ProvidedStrategy
implements IdStrategy {
    private ProvidedIn where;

    ProvidedStrategy(ProvidedIn where) {
        this.where = where;
    }

    @Override
    public BsonValue generateId(SinkDocument doc, SinkRecord orig) {
        BsonValue id;
        Optional<Object> optionalDoc = Optional.empty();
        if (this.where.equals((Object)ProvidedIn.KEY)) {
            optionalDoc = doc.getKeyDoc();
        }
        if (this.where.equals((Object)ProvidedIn.VALUE)) {
            optionalDoc = doc.getValueDoc();
        }
        if ((id = optionalDoc.map(d -> d.get((Object)"_id")).orElseThrow(() -> new DataException("Provided id strategy is used but the document structure either contained no _id field or it was null"))) instanceof BsonNull) {
            throw new DataException("Provided id strategy used but the document structure contained an _id of type BsonNull");
        }
        return id;
    }

    protected static enum ProvidedIn {
        KEY,
        VALUE;

    }
}

