/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.schema;

import com.mongodb.kafka.connect.source.schema.SchemaDebugHelper;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Timestamp;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BsonDocumentToSchema {
    public static final String DEFAULT_FIELD_NAME = "default";
    private static final Logger LOGGER = LoggerFactory.getLogger(BsonDocumentToSchema.class);
    private static final String ID_FIELD = "_id";
    static final Schema INCOMPATIBLE_SCHEMA_TYPE = Schema.OPTIONAL_STRING_SCHEMA;
    static final Schema SENTINEL_STRING_TYPE = SchemaBuilder.type((Schema.Type)Schema.Type.STRING).optional().build();

    public static Schema inferDocumentSchema(BsonDocument document) {
        return BsonDocumentToSchema.createSchemaBuilder(DEFAULT_FIELD_NAME, document).required().build();
    }

    private static Schema inferDocumentSchema(String fieldPath, BsonDocument document) {
        return BsonDocumentToSchema.createSchemaBuilder(fieldPath, document).optional().build();
    }

    private static Schema inferArraySchema(String fieldPath, BsonArray bsonArray) {
        BsonValue v;
        Schema combinedSchema = SENTINEL_STRING_TYPE;
        Iterator iterator = bsonArray.iterator();
        while (iterator.hasNext() && (combinedSchema = BsonDocumentToSchema.combinedSchema(combinedSchema, BsonDocumentToSchema.inferSchema(fieldPath, v = (BsonValue)iterator.next()))) != INCOMPATIBLE_SCHEMA_TYPE) {
        }
        return SchemaBuilder.array((Schema)combinedSchema).name(fieldPath).optional().build();
    }

    private static SchemaBuilder createSchemaBuilder(String fieldPath, BsonDocument document) {
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.name(fieldPath);
        if (document.containsKey((Object)ID_FIELD)) {
            builder.field(ID_FIELD, BsonDocumentToSchema.inferSchema(ID_FIELD, document.get((Object)ID_FIELD)));
        }
        document.entrySet().stream().filter(kv -> !((String)kv.getKey()).equals(ID_FIELD)).sorted(Map.Entry.comparingByKey()).forEach(kv -> builder.field((String)kv.getKey(), BsonDocumentToSchema.inferSchema(BsonDocumentToSchema.createFieldPath(fieldPath, (String)kv.getKey()), (BsonValue)kv.getValue())));
        return builder;
    }

    private static Schema inferSchema(String fieldPath, BsonValue bsonValue) {
        switch (bsonValue.getBsonType()) {
            case BOOLEAN: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case INT32: {
                return Schema.OPTIONAL_INT32_SCHEMA;
            }
            case INT64: {
                return Schema.OPTIONAL_INT64_SCHEMA;
            }
            case DOUBLE: {
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case DECIMAL128: {
                return Decimal.builder((int)bsonValue.asDecimal128().getValue().bigDecimalValue().scale()).optional().build();
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                return Timestamp.builder().optional().build();
            }
            case DOCUMENT: {
                return BsonDocumentToSchema.inferDocumentSchema(fieldPath, bsonValue.asDocument());
            }
            case ARRAY: {
                return BsonDocumentToSchema.inferArraySchema(fieldPath, bsonValue.asArray());
            }
            case BINARY: {
                return Schema.OPTIONAL_BYTES_SCHEMA;
            }
            case NULL: {
                return SENTINEL_STRING_TYPE;
            }
        }
        return Schema.OPTIONAL_STRING_SCHEMA;
    }

    private static Schema combinedSchema(Schema firstSchema, Schema secondSchema) {
        if (BsonDocumentToSchema.isSentinel(firstSchema)) {
            return secondSchema;
        }
        if (BsonDocumentToSchema.isSentinel(secondSchema)) {
            return firstSchema;
        }
        if (firstSchema.equals(secondSchema)) {
            return firstSchema;
        }
        if (firstSchema.type() != secondSchema.type()) {
            BsonDocumentToSchema.logIncompatibleSchemas(firstSchema, secondSchema);
            return INCOMPATIBLE_SCHEMA_TYPE;
        }
        switch (firstSchema.type()) {
            case ARRAY: {
                SchemaBuilder arrayBuilder = SchemaBuilder.array((Schema)BsonDocumentToSchema.combinedSchema(firstSchema.valueSchema(), secondSchema.valueSchema())).name(firstSchema.name()).optional();
                return arrayBuilder.build();
            }
            case STRUCT: {
                SchemaBuilder structBuilder = SchemaBuilder.struct().name(firstSchema.name()).optional();
                Field id1 = firstSchema.field(ID_FIELD);
                Field id2 = secondSchema.field(ID_FIELD);
                if (id1 != null || id2 != null) {
                    structBuilder.field(ID_FIELD, BsonDocumentToSchema.combineFieldSchema(id1, id2));
                }
                Stream.concat(firstSchema.fields().stream().map(Field::name), secondSchema.fields().stream().map(Field::name)).filter(name -> !name.equals(ID_FIELD)).distinct().sorted().forEach(name -> structBuilder.field(name, BsonDocumentToSchema.combineFieldSchema(firstSchema.field(name), secondSchema.field(name))));
                return structBuilder.build();
            }
        }
        BsonDocumentToSchema.logIncompatibleSchemas(firstSchema, secondSchema);
        return INCOMPATIBLE_SCHEMA_TYPE;
    }

    private static Schema combineFieldSchema(Field firstField, Field secondField) {
        if (firstField == null) {
            return secondField.schema();
        }
        if (secondField == null) {
            return firstField.schema();
        }
        if (firstField.schema().equals(secondField.schema())) {
            return firstField.schema();
        }
        if (BsonDocumentToSchema.isSentinel(firstField.schema())) {
            return secondField.schema();
        }
        if (BsonDocumentToSchema.isSentinel(secondField.schema())) {
            return firstField.schema();
        }
        return BsonDocumentToSchema.combinedSchema(firstField.schema(), secondField.schema());
    }

    static boolean isSentinel(Schema schema) {
        return schema == SENTINEL_STRING_TYPE;
    }

    private static String createFieldPath(String fieldPath, String fieldName) {
        if (fieldPath.equals(DEFAULT_FIELD_NAME)) {
            return fieldName;
        }
        return fieldPath + "_" + fieldName;
    }

    private static void logIncompatibleSchemas(Schema firstSchema, Schema secondSchema) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Incompatible Schemas: {}", (Object)SchemaDebugHelper.prettyPrintSchemas(firstSchema, secondSchema));
        }
    }

    private BsonDocumentToSchema() {
    }
}

