/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public final class BsonDocumentFieldLookup {
    public static Optional<BsonValue> fieldLookup(String fieldPath, BsonDocument document) {
        if (document.containsKey((Object)fieldPath)) {
            return Optional.of(document.get((Object)fieldPath));
        }
        if (fieldPath.contains(".") && !fieldPath.endsWith(".")) {
            String subDocumentName = fieldPath.substring(0, fieldPath.indexOf("."));
            String subDocumentFieldName = fieldPath.substring(fieldPath.indexOf(".") + 1);
            if (document.isDocument((Object)subDocumentName)) {
                return BsonDocumentFieldLookup.fieldLookup(subDocumentFieldName, document.getDocument((Object)subDocumentName));
            }
        }
        return Optional.empty();
    }

    private BsonDocumentFieldLookup() {
    }
}

