/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.converter;

import com.mongodb.kafka.connect.sink.converter.RecordConverter;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonDocumentCodec;

class ByteArrayRecordConverter
implements RecordConverter {
    private static final BsonDocumentCodec BSON_DOCUMENT_CODEC = new BsonDocumentCodec();

    ByteArrayRecordConverter() {
    }

    @Override
    public BsonDocument convert(Schema schema, Object value) {
        if (value == null) {
            throw new DataException("Value was null for BSON conversion");
        }
        return new RawBsonDocument((byte[])value).decode(BSON_DOCUMENT_CODEC);
    }
}

