/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.converter;

import com.mongodb.lang.Nullable;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class LazyBsonDocument
extends BsonDocument {
    private static final long serialVersionUID = 1L;
    private final transient SinkRecord record;
    private final transient Type dataType;
    private final transient BiFunction<Schema, Object, BsonDocument> converter;
    private BsonDocument unwrapped;

    public LazyBsonDocument(SinkRecord record, Type dataType, BiFunction<Schema, Object, BsonDocument> converter) {
        if (record == null) {
            throw new IllegalArgumentException("record can not be null");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("dataType can not be null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("converter can not be null");
        }
        this.record = record;
        this.dataType = dataType;
        this.converter = converter;
    }

    @Override
    public int size() {
        return this.getUnwrapped().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getUnwrapped().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getUnwrapped().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getUnwrapped().containsValue(value);
    }

    @Override
    public BsonValue get(Object key) {
        return this.getUnwrapped().get(key);
    }

    @Override
    public BsonValue put(String key, BsonValue value) {
        return this.getUnwrapped().put(key, value);
    }

    @Override
    public BsonValue remove(Object key) {
        return this.getUnwrapped().remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends BsonValue> m) {
        this.getUnwrapped().putAll(m);
    }

    @Override
    public void clear() {
        this.getUnwrapped().clear();
    }

    @Override
    public Set<String> keySet() {
        return this.getUnwrapped().keySet();
    }

    @Override
    public Collection<BsonValue> values() {
        return this.getUnwrapped().values();
    }

    @Override
    public Set<Map.Entry<String, BsonValue>> entrySet() {
        return this.getUnwrapped().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.getUnwrapped().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getUnwrapped().hashCode();
    }

    @Override
    public String toString() {
        return this.getUnwrapped().toString();
    }

    @Override
    public BsonDocument clone() {
        return this.unwrapped != null ? this.unwrapped.clone() : new LazyBsonDocument(this.record, this.dataType, this.converter);
    }

    private BsonDocument getUnwrapped() {
        if (this.unwrapped == null) {
            switch (this.dataType) {
                case KEY: {
                    try {
                        this.unwrapped = this.converter.apply(this.record.keySchema(), this.record.key());
                        break;
                    }
                    catch (Exception e) {
                        throw new DataException(String.format("Could not convert key %s into a BsonDocument.", LazyBsonDocument.unambiguousToString(this.record.key())), (Throwable)e);
                    }
                }
                case VALUE: {
                    try {
                        this.unwrapped = this.converter.apply(this.record.valueSchema(), this.record.value());
                        break;
                    }
                    catch (Exception e) {
                        throw new DataException(String.format("Could not convert value %s into a BsonDocument.", LazyBsonDocument.unambiguousToString(this.record.value())), (Throwable)e);
                    }
                }
                default: {
                    throw new DataException(String.format("Unknown data type %s.", new Object[]{this.dataType}));
                }
            }
        }
        return this.unwrapped;
    }

    private Object writeReplace() {
        return this.getUnwrapped();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static String unambiguousToString(@Nullable Object v) {
        String vToString = String.valueOf(v);
        if (v == null) {
            return String.format("'%s' (null reference)", vToString);
        }
        if (vToString.equals(String.valueOf(null))) {
            return String.format("'%s' (%s, not a null reference)", vToString, v.getClass().getName());
        }
        return String.format("'%s' (%s)", vToString, v.getClass().getName());
    }

    public static enum Type {
        KEY,
        VALUE;

    }
}

