/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.topic.mapping;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.kafka.connect.source.MongoSourceConfig;
import com.mongodb.kafka.connect.source.topic.mapping.TopicMapper;
import com.mongodb.kafka.connect.util.Assertions;
import com.mongodb.kafka.connect.util.BsonDocumentFieldLookup;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ConnectConfigException;
import com.mongodb.lang.Nullable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonDocument;
import org.bson.Document;

@NotThreadSafe
public class DefaultTopicMapper
implements TopicMapper {
    private static final String DB_FIELD_PATH = "ns.db";
    private static final String COLL_FIELD_PATH = "ns.coll";
    private static final String REGEX_NAMESPACE_PATTERN_MARK = "/";
    private static final String WILDCARD_NAMESPACE_PATTERN = "*";
    private static final char NAMESPACE_SEPARATOR = '.';
    private String separator;
    private String prefix;
    private String suffix;
    private Map<String, String> simplePairs;
    private List<Map.Entry<Matcher, TopicNameTemplate>> regexPairs;
    @Nullable
    private String undecoratedWildcardTopicName;
    private final Map<String, String> namespaceTopicCache = new HashMap<String, String>();

    @Override
    public void configure(MongoSourceConfig config) {
        ConfigExceptionSupplier configExceptionSupplier = message -> new ConnectConfigException("topic.namespace.map", config.getString("topic.namespace.map"), (String)message);
        String prefix = config.getString("topic.prefix");
        String suffix = config.getString("topic.suffix");
        this.separator = config.getString("topic.separator");
        this.prefix = prefix.isEmpty() ? prefix : prefix + this.separator;
        this.suffix = suffix.isEmpty() ? suffix : this.separator + suffix;
        Document topicNamespaceMap = ConfigHelper.documentFromString(config.getString("topic.namespace.map")).orElse(new Document());
        this.simplePairs = new HashMap<String, String>();
        this.regexPairs = new ArrayList<Map.Entry<Matcher, TopicNameTemplate>>();
        for (Map.Entry<String, Object> pair2 : topicNamespaceMap.entrySet()) {
            String namespacePattern = pair2.getKey();
            Object value = pair2.getValue();
            if (!(value instanceof String)) {
                throw (ConnectConfigException)((Object)configExceptionSupplier.apply("All values must be strings"));
            }
            String topicNameTemplate = (String)pair2.getValue();
            if (namespacePattern.equals(WILDCARD_NAMESPACE_PATTERN)) {
                this.undecoratedWildcardTopicName = topicNameTemplate;
                continue;
            }
            if (namespacePattern.startsWith(REGEX_NAMESPACE_PATTERN_MARK)) {
                this.regexPairs.add(new AbstractMap.SimpleImmutableEntry<Matcher, TopicNameTemplate>(DefaultTopicMapper.regexMatcher(namespacePattern.substring(REGEX_NAMESPACE_PATTERN_MARK.length()), configExceptionSupplier), new TopicNameTemplate(topicNameTemplate, this.separator, configExceptionSupplier)));
                continue;
            }
            if (namespacePattern.contains(REGEX_NAMESPACE_PATTERN_MARK)) {
                throw (ConnectConfigException)((Object)configExceptionSupplier.apply(String.format("'%s' is not allowed in a simple namespace pattern", REGEX_NAMESPACE_PATTERN_MARK)));
            }
            this.simplePairs.put(namespacePattern, topicNameTemplate);
        }
        this.simplePairs.entrySet().removeIf(pair -> ((String)pair.getValue()).isEmpty());
        this.regexPairs.removeIf(pair -> ((TopicNameTemplate)pair.getValue()).isEmpty());
        if (this.undecoratedWildcardTopicName != null && this.undecoratedWildcardTopicName.isEmpty()) {
            this.undecoratedWildcardTopicName = null;
        }
    }

    @Override
    public String getTopic(BsonDocument changeStreamDocument) {
        String dbName = this.getStringFromPath(DB_FIELD_PATH, changeStreamDocument);
        if (dbName.isEmpty()) {
            return "";
        }
        String collName = this.getStringFromPath(COLL_FIELD_PATH, changeStreamDocument);
        String namespace = DefaultTopicMapper.namespace(dbName, collName);
        String cachedTopic = this.namespaceTopicCache.get(namespace);
        if (cachedTopic == null) {
            cachedTopic = this.decorateTopicName(this.getUndecoratedTopicName(dbName, collName));
            this.namespaceTopicCache.put(namespace, cachedTopic);
        }
        return cachedTopic;
    }

    private String getStringFromPath(String fieldPath, BsonDocument changeStreamDocument) {
        return BsonDocumentFieldLookup.fieldLookup(fieldPath, changeStreamDocument).map(bsonValue -> bsonValue.isString() ? bsonValue.asString().getValue() : "").orElse("");
    }

    private String getUndecoratedTopicName(String dbName, String collName) {
        Assertions.assertFalse(dbName.isEmpty());
        String namespace = DefaultTopicMapper.namespace(dbName, collName);
        String topicNameTemplate = this.simplePairs.get(namespace);
        if (topicNameTemplate != null) {
            return topicNameTemplate;
        }
        topicNameTemplate = this.simplePairs.get(dbName);
        if (topicNameTemplate != null) {
            return this.undecoratedTopicName(topicNameTemplate, collName);
        }
        String undecoratedTopicName = this.regexPairs.stream().filter(pair -> ((Matcher)pair.getKey()).reset(namespace).matches()).findFirst().map(pair -> ((TopicNameTemplate)pair.getValue()).compute(dbName, collName)).orElse(null);
        if (undecoratedTopicName != null) {
            return undecoratedTopicName;
        }
        if (this.undecoratedWildcardTopicName != null) {
            return this.undecoratedWildcardTopicName;
        }
        return this.undecoratedTopicName(dbName, collName);
    }

    private static String namespace(String dbName, String collName) {
        return collName.isEmpty() ? dbName : dbName + '.' + collName;
    }

    private String undecoratedTopicName(String dbNameOrMappedTopicNamePart, String collName) {
        return collName.isEmpty() ? dbNameOrMappedTopicNamePart : dbNameOrMappedTopicNamePart + this.separator + collName;
    }

    private String decorateTopicName(String undecoratedTopicName) {
        return this.prefix + undecoratedTopicName + this.suffix;
    }

    private static Matcher regexMatcher(String regex, ConfigExceptionSupplier configExceptionSupplier) throws ConnectConfigException {
        try {
            return Pattern.compile(regex).matcher("");
        }
        catch (PatternSyntaxException e) {
            throw (ConnectConfigException)((Object)configExceptionSupplier.apply(e.getMessage()));
        }
    }

    @FunctionalInterface
    private static interface ConfigExceptionSupplier
    extends Function<String, ConnectConfigException> {
    }

    private static final class TopicNameTemplate {
        private static final char START_VAR_NAME = '{';
        private static final char END_VAR_NAME = '}';
        private final String compiledTemplate;
        private final ArrayList<Map.Entry<Integer, VarName>> varExpansions;
        private final String separator;
        private final StringBuilder builder;

        TopicNameTemplate(String template, String separator, ConfigExceptionSupplier configExceptionSupplier) throws ConnectConfigException {
            this.builder = new StringBuilder(template.length());
            this.varExpansions = new ArrayList();
            this.compiledTemplate = TopicNameTemplate.compile(template, separator, this.builder, this.varExpansions, configExceptionSupplier);
            this.separator = separator;
        }

        String compute(String dbName, String collName) {
            Assertions.assertFalse(this.isEmpty());
            if (this.varExpansions.isEmpty()) {
                return this.compiledTemplate;
            }
            this.builder.setLength(0);
            this.builder.append(this.compiledTemplate);
            int varExpansionIdxOffset = 0;
            for (Map.Entry<Integer, VarName> varExpansion : this.varExpansions) {
                int idx = varExpansion.getKey();
                VarName varName = varExpansion.getValue();
                String varValue = varName.computeValue(dbName, collName, this.separator);
                if (varValue.isEmpty()) continue;
                this.builder.insert(idx + varExpansionIdxOffset, varValue);
                varExpansionIdxOffset += varValue.length();
            }
            return this.builder.toString();
        }

        boolean isEmpty() {
            return this.compiledTemplate.isEmpty() && this.varExpansions.isEmpty();
        }

        public String toString() {
            return "TopicNameTemplate{compiledTemplate='" + this.compiledTemplate + '\'' + ", varExpansions=" + this.varExpansions + ", separator='" + this.separator + '\'' + '}';
        }

        private static String compile(String template, String separator, StringBuilder compiledTemplateBuilder, ArrayList<Map.Entry<Integer, VarName>> varExpansions, ConfigExceptionSupplier configExceptionSupplier) throws ConnectConfigException {
            String varExpansionErrorMessageFormat = "Variable expansion syntax is violated, unexpected '%c'";
            int balance = 0;
            int firstUncompiledIdx = 0;
            int varPlaceholderStartIdx = -1;
            int varExpansionIdxOffset = 0;
            char[] chars = template.toCharArray();
            block4: for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                switch (c) {
                    case '{': {
                        TopicNameTemplate.throwIfInvalidBalance(++balance, 0, 1, varExpansionErrorMessageFormat, configExceptionSupplier);
                        varPlaceholderStartIdx = i;
                        continue block4;
                    }
                    case '}': {
                        TopicNameTemplate.throwIfInvalidBalance(--balance, 0, 1, varExpansionErrorMessageFormat, configExceptionSupplier);
                        int varPlaceholderLength = i - varPlaceholderStartIdx + 1;
                        VarName varName = VarName.of(template.substring(varPlaceholderStartIdx + 1, i), configExceptionSupplier);
                        compiledTemplateBuilder.append(template, firstUncompiledIdx, varPlaceholderStartIdx);
                        if (varName == VarName.SEP) {
                            compiledTemplateBuilder.append(separator);
                            varExpansionIdxOffset -= separator.length();
                        } else {
                            varExpansions.add(new AbstractMap.SimpleImmutableEntry<Integer, VarName>(varPlaceholderStartIdx - varExpansionIdxOffset, varName));
                        }
                        varExpansionIdxOffset += varPlaceholderLength;
                        firstUncompiledIdx = i + 1;
                        continue block4;
                    }
                }
            }
            TopicNameTemplate.throwIfInvalidBalance(balance, 0, 0, varExpansionErrorMessageFormat, configExceptionSupplier);
            compiledTemplateBuilder.append(template, firstUncompiledIdx, template.length());
            return compiledTemplateBuilder.toString();
        }

        private static void throwIfInvalidBalance(int balance, int minBalance, int maxBalance, String errorMessageFormat, ConfigExceptionSupplier configExceptionSupplier) throws ConnectConfigException {
            if (balance < minBalance) {
                throw (ConnectConfigException)((Object)configExceptionSupplier.apply(String.format(Locale.ROOT, errorMessageFormat, Character.valueOf('}'))));
            }
            if (balance > maxBalance) {
                throw (ConnectConfigException)((Object)configExceptionSupplier.apply(String.format(Locale.ROOT, errorMessageFormat, Character.valueOf('{'))));
            }
        }

        private static enum VarName {
            DB((dbName, collName, separator) -> dbName),
            SEP((dbName, collName, separator) -> separator),
            COLL((dbName, collName, separator) -> collName),
            SEP_COLL((dbName, collName, separator) -> collName.isEmpty() ? "" : separator + collName),
            COLL_SEP((dbName, collName, separator) -> collName.isEmpty() ? "" : collName + separator),
            SEP_COLL_SEP((dbName, collName, separator) -> collName.isEmpty() ? "" : separator + collName + separator);

            private static final Set<String> SUPPORTED_VAR_NAMES;
            private final ValueComputer valueComputer;

            private VarName(ValueComputer computer) {
                this.valueComputer = computer;
            }

            String computeValue(String dbName, String collName, String separator) {
                return this.valueComputer.compute(dbName, collName, separator);
            }

            static VarName of(String s, ConfigExceptionSupplier configExceptionSupplier) throws ConnectConfigException {
                if (!SUPPORTED_VAR_NAMES.contains(s)) {
                    throw (ConnectConfigException)((Object)configExceptionSupplier.apply(s + " is not a supported variable name"));
                }
                return VarName.valueOf(s.toUpperCase(Locale.ROOT));
            }

            static {
                SUPPORTED_VAR_NAMES = Stream.of(VarName.values()).map(Enum::name).map(varName -> varName.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            }

            @FunctionalInterface
            private static interface ValueComputer {
                public String compute(String var1, String var2, String var3);
            }
        }
    }
}

