/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import com.mongodb.MongoDriverInformation;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.bson.Document;

public final class ConfigHelper {
    private ConfigHelper() {
    }

    public static Optional<List<Document>> jsonArrayFromString(String jsonArray) {
        return ConfigHelper.jsonArrayFromString(jsonArray, null);
    }

    public static Optional<Document> documentFromString(String jsonDocument) {
        return ConfigHelper.documentFromString(jsonDocument, null);
    }

    public static Optional<Document> documentFromString(String jsonDocument, ConfigException originalError) {
        if (jsonDocument.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Document.parse(jsonDocument));
        }
        catch (Exception e) {
            if (originalError != null) {
                throw originalError;
            }
            return ConfigHelper.documentFromString(jsonDocument.replace("\\", "\\\\"), new ConfigException("Not a valid JSON document", (Object)e));
        }
    }

    private static Optional<List<Document>> jsonArrayFromString(String jsonArray, ConfigException originalError) {
        if (jsonArray.isEmpty()) {
            return Optional.empty();
        }
        try {
            List<Document> s = Document.parse(String.format("{s: %s}", jsonArray)).getList("s", Document.class);
            return s.isEmpty() ? Optional.empty() : Optional.of(s);
        }
        catch (Exception e) {
            if (originalError != null) {
                throw originalError;
            }
            return ConfigHelper.jsonArrayFromString(jsonArray.replace("\\", "\\\\"), new ConfigException("Not a valid JSON array", (Object)e));
        }
    }

    public static Optional<FullDocumentBeforeChange> fullDocumentBeforeChangeFromString(String s) {
        if (s.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(FullDocumentBeforeChange.fromString(s));
    }

    public static Optional<FullDocument> fullDocumentFromString(String fullDocument) {
        if (fullDocument.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(FullDocument.fromString(fullDocument));
    }

    public static Optional<Collation> collationFromJson(String collationString) {
        if (collationString.isEmpty()) {
            return Optional.empty();
        }
        Collation.Builder builder = Collation.builder();
        Document collationDoc = Document.parse(collationString);
        if (collationDoc.containsKey("locale")) {
            builder.locale(collationDoc.getString("locale"));
        }
        if (collationDoc.containsKey("caseLevel")) {
            builder.caseLevel(collationDoc.getBoolean("caseLevel"));
        }
        if (collationDoc.containsKey("caseFirst")) {
            builder.collationCaseFirst(CollationCaseFirst.fromString(collationDoc.getString("caseFirst")));
        }
        if (collationDoc.containsKey("strength")) {
            builder.collationStrength(CollationStrength.fromInt(collationDoc.getInteger("strength")));
        }
        if (collationDoc.containsKey("numericOrdering")) {
            builder.numericOrdering(collationDoc.getBoolean("numericOrdering"));
        }
        if (collationDoc.containsKey("alternate")) {
            builder.collationAlternate(CollationAlternate.fromString(collationDoc.getString("alternate")));
        }
        if (collationDoc.containsKey("maxVariable")) {
            builder.collationMaxVariable(CollationMaxVariable.fromString(collationDoc.getString("maxVariable")));
        }
        if (collationDoc.containsKey("normalization")) {
            builder.normalization(collationDoc.getBoolean("normalization"));
        }
        if (collationDoc.containsKey("backwards")) {
            builder.backwards(collationDoc.getBoolean("backwards"));
        }
        return Optional.of(builder.build());
    }

    public static MongoDriverInformation getMongoDriverInformation(String type, String provider) {
        String name = "mongo-kafka|" + type;
        if (!provider.isEmpty()) {
            name = name + "|" + provider;
        }
        return MongoDriverInformation.builder().driverName(name).driverVersion("1.13.0").build();
    }

    public static String getOverrideOrDefault(AbstractConfig config, String overrideConfig, String defaultConfig) {
        String stringConfig = config.getString(overrideConfig);
        if (stringConfig.isEmpty()) {
            stringConfig = config.getString(defaultConfig);
        }
        return stringConfig;
    }

    public static <C extends AbstractConfig, T> T getOverrideOrFallback(C config, BiFunction<? super C, String, T> getter, String overrideProperty, String defaultProperty) {
        String propertyToRead = config.originals().containsKey(overrideProperty) ? overrideProperty : defaultProperty;
        return getter.apply(config, propertyToRead);
    }

    public static Optional<ConfigValue> getConfigByName(Config config, String name) {
        return config.configValues().stream().filter(cv -> cv.name().equals(name)).findFirst();
    }

    public static Optional<ConfigValue> getConfigByNameWithoutErrors(Config config, String name) {
        Optional<ConfigValue> configByName = ConfigHelper.getConfigByName(config, name);
        if (configByName.isPresent() && configByName.get().errorMessages().isEmpty()) {
            return configByName;
        }
        return Optional.empty();
    }

    public static Config evaluateConfigValues(Config rawConfig, AbstractConfig resolvedConfig) {
        Map evalValues = resolvedConfig.values();
        rawConfig.configValues().forEach(configValue -> {
            Object ev = evalValues.get(configValue.name());
            if (ev != null) {
                configValue.value(ev);
            }
        });
        return rawConfig;
    }

    public static Map<String, String> evaluateConfigValues(Map<String, String> rawConfigs, AbstractConfig resolvedConfig) {
        HashMap<String, String> resolvedRawConfigs = new HashMap<String, String>(rawConfigs);
        Map originals = resolvedConfig.originals();
        rawConfigs.forEach((key, val) -> {
            Object ev = originals.get(key);
            if (ev instanceof String) {
                resolvedRawConfigs.put((String)key, (String)ev);
            }
        });
        return resolvedRawConfigs;
    }
}

