/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.field.projection;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.processor.field.projection.FieldProjector;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public abstract class AllowListProjector
extends FieldProjector {
    public AllowListProjector(MongoSinkTopicConfig config, Set<String> fields, FieldProjector.SinkDocumentField sinkDocumentField) {
        super(config, fields, sinkDocumentField);
    }

    @Override
    protected void projectDocument(BsonDocument doc) {
        this.doProjection("", doc);
    }

    private void doProjection(String field, BsonDocument doc) {
        if (this.getFields().contains("**")) {
            return;
        }
        Iterator iter = doc.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String key = field.isEmpty() ? (String)entry.getKey() : field + "." + (String)entry.getKey();
            BsonValue value = (BsonValue)entry.getValue();
            if (!this.getFields().contains(key) && !this.checkForWildcardMatch(key)) {
                iter.remove();
            }
            if (value == null) continue;
            if (value.isDocument()) {
                String matchDoubleWildCard = key + "." + "**";
                if (!this.getFields().contains(matchDoubleWildCard)) {
                    this.doProjection(key, (BsonDocument)value);
                }
            }
            if (!value.isArray()) continue;
            BsonArray values = value.asArray();
            for (BsonValue v : values.getValues()) {
                if (v == null || !v.isDocument()) continue;
                this.doProjection(key, (BsonDocument)v);
            }
        }
    }

    private boolean checkForWildcardMatch(String key) {
        if (this.checkForStartsWithWildcardMatch(key)) {
            return true;
        }
        String[] keyParts = key.split("\\.");
        Object[] pattern = new String[keyParts.length];
        Arrays.fill(pattern, "*");
        for (int c = (int)Math.pow(2.0, keyParts.length) - 1; c >= 0; --c) {
            int mask = 1;
            for (int d = keyParts.length - 1; d >= 0; --d) {
                if ((c & mask) != 0) {
                    pattern[d] = keyParts[d];
                }
                mask <<= 1;
            }
            if (this.getFields().contains(String.join((CharSequence)".", (CharSequence[])pattern))) {
                return true;
            }
            Arrays.fill(pattern, "*");
        }
        return false;
    }

    private boolean checkForStartsWithWildcardMatch(String key) {
        return this.getFields().stream().filter(f -> !f.contains(".") && !f.equals("*") && f.endsWith("*")).map(f -> f.substring(0, f.length() - 1)).anyMatch(key::startsWith);
    }
}

