/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.PostProcessor;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class NullFieldValueRemover
extends PostProcessor {
    public NullFieldValueRemover(MongoSinkTopicConfig config) {
        super(config);
    }

    @Override
    public void process(SinkDocument doc, SinkRecord orig) {
        doc.getValueDoc().ifPresent(this::removeNullFieldValues);
    }

    private void removeNullFieldValues(BsonDocument doc) {
        doc.entrySet().removeIf(entry -> {
            BsonValue value = (BsonValue)entry.getValue();
            if (value.isDocument()) {
                this.removeNullFieldValues(value.asDocument());
            }
            if (value.isArray()) {
                value.asArray().stream().filter(BsonValue::isDocument).forEach(element -> this.removeNullFieldValues(element.asDocument()));
            }
            return value.isNull();
        });
    }
}

