/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.id.strategy;

import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.id.strategy.ProvidedStrategy;
import java.util.UUID;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonValue;
import org.bson.UuidRepresentation;

abstract class UuidProvidedStrategy
extends ProvidedStrategy {
    private static final int UUID_LENGTH = 36;
    private static final int UUID_LENGTH_NO_DASHES = 32;

    UuidProvidedStrategy(ProvidedStrategy.ProvidedIn where) {
        super(where);
    }

    @Override
    public BsonValue generateId(SinkDocument doc, SinkRecord orig) {
        BsonValue id = super.generateId(doc, orig);
        if (id.isBinary() && BsonBinarySubType.isUuid((byte)id.asBinary().getType())) {
            return id;
        }
        if (id.isString()) {
            return new BsonBinary(this.constructUuidObjectFromString(id.asString().getValue()), UuidRepresentation.STANDARD);
        }
        throw new DataException(String.format("UUID cannot be constructed from provided value: `%s`", id));
    }

    private UUID constructUuidObjectFromString(String uuid) {
        try {
            if (uuid.length() == 36) {
                return UUID.fromString(uuid);
            }
            if (uuid.length() == 32) {
                return UUID.fromString(uuid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new DataException(String.format("UUID cannot be constructed from provided value: `%s`", uuid));
    }
}

