/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink;

import com.mongodb.client.model.TimeSeriesGranularity;
import com.mongodb.kafka.connect.sink.Configurable;
import com.mongodb.kafka.connect.sink.RateLimitSettings;
import com.mongodb.kafka.connect.sink.cdc.CdcHandler;
import com.mongodb.kafka.connect.sink.namespace.mapping.NamespaceMapper;
import com.mongodb.kafka.connect.sink.processor.PostProcessors;
import com.mongodb.kafka.connect.sink.processor.id.strategy.FullKeyStrategy;
import com.mongodb.kafka.connect.sink.processor.id.strategy.IdStrategy;
import com.mongodb.kafka.connect.sink.processor.id.strategy.PartialKeyStrategy;
import com.mongodb.kafka.connect.sink.processor.id.strategy.ProvidedInKeyStrategy;
import com.mongodb.kafka.connect.sink.writemodel.strategy.DeleteOneDefaultStrategy;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelStrategy;
import com.mongodb.kafka.connect.util.ClassHelper;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ConnectConfigException;
import com.mongodb.kafka.connect.util.FlexibleDateTimeParser;
import com.mongodb.kafka.connect.util.Validators;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;

public class MongoSinkTopicConfig
extends AbstractConfig {
    private static final String EMPTY_STRING = "";
    private static final String TOPIC_CONFIG = "topic";
    static final String TOPIC_OVERRIDE_PREFIX = "topic.override.";
    public static final String DATABASE_CONFIG = "database";
    private static final String DATABASE_DISPLAY = "The MongoDB database name.";
    private static final String DATABASE_DOC = "The database for the sink to write.";
    public static final String COLLECTION_CONFIG = "collection";
    private static final String COLLECTION_DISPLAY = "The default MongoDB collection name";
    private static final String COLLECTION_DOC = "Optional, single sink collection name to write to. If following multiple topics then this will be the default collection they are mapped to.";
    private static final String COLLECTION_DEFAULT = "";
    public static final String NAMESPACE_MAPPER_CONFIG = "namespace.mapper";
    private static final String NAMESPACE_MAPPER_DISPLAY = "The namespace mapper class";
    private static final String NAMESPACE_MAPPER_DOC = "The class that determines the namespace to write the sink data to. By default this will be based on the 'database' configuration and either the topic name or the 'collection' configuration. Users can provide their own implementations of the 'NamespaceMapper' interface.";
    private static final String NAMESPACE_MAPPER_DEFAULT = "com.mongodb.kafka.connect.sink.namespace.mapping.DefaultNamespaceMapper";
    public static final String FIELD_KEY_DATABASE_NAMESPACE_MAPPER_CONFIG = "namespace.mapper.key.database.field";
    private static final String FIELD_KEY_DATABASE_NAMESPACE_MAPPER_DISPLAY = "The key field to use as the destination database name.";
    private static final String FIELD_KEY_DATABASE_NAMESPACE_MAPPER_DOC = "The key field to use as the destination database name. Requires the 'namespace.mapper' to be set to 'com.mongodb.kafka.connect.sink.topic.mapping.FieldPathNamespaceMapper'.";
    private static final String FIELD_KEY_DATABASE_NAMESPACE_MAPPER_DEFAULT = "";
    public static final String FIELD_KEY_COLLECTION_NAMESPACE_MAPPER_CONFIG = "namespace.mapper.key.collection.field";
    private static final String FIELD_KEY_COLLECTION_NAMESPACE_MAPPER_DISPLAY = "The key field to use as the destination collection name.";
    private static final String FIELD_KEY_COLLECTION_NAMESPACE_MAPPER_DOC = "The key field to use as the destination collection name. Requires the 'namespace.mapper' to be set to 'com.mongodb.kafka.connect.sink.topic.mapping.FieldPathNamespaceMapper'.";
    private static final String FIELD_KEY_COLLECTION_NAMESPACE_MAPPER_DEFAULT = "";
    public static final String FIELD_VALUE_DATABASE_NAMESPACE_MAPPER_CONFIG = "namespace.mapper.value.database.field";
    private static final String FIELD_VALUE_DATABASE_NAMESPACE_MAPPER_DISPLAY = "The value field to use as the destination database name.";
    private static final String FIELD_VALUE_DATABASE_NAMESPACE_MAPPER_DOC = "The value field to use as the destination database name. Requires the 'namespace.mapper' to be set to 'com.mongodb.kafka.connect.sink.topic.mapping.FieldPathNamespaceMapper'.";
    private static final String FIELD_VALUE_DATABASE_NAMESPACE_MAPPER_DEFAULT = "";
    public static final String FIELD_VALUE_COLLECTION_NAMESPACE_MAPPER_CONFIG = "namespace.mapper.value.collection.field";
    private static final String FIELD_VALUE_COLLECTION_NAMESPACE_MAPPER_DISPLAY = "The value field to use as the destination collection name.";
    private static final String FIELD_VALUE_COLLECTION_NAMESPACE_MAPPER_DOC = "The value field to use as the destination collection name. Requires the 'namespace.mapper' to be set to 'com.mongodb.kafka.connect.sink.topic.mapping.FieldPathNamespaceMapper'.";
    private static final String FIELD_VALUE_COLLECTION_NAMESPACE_MAPPER_DEFAULT = "";
    public static final String FIELD_NAMESPACE_MAPPER_ERROR_IF_INVALID_CONFIG = "namespace.mapper.error.if.invalid";
    private static final String FIELD_NAMESPACE_MAPPER_ERROR_IF_INVALID_DISPLAY = "Throw an error if the mapped field is missing or invalid.";
    private static final String FIELD_NAMESPACE_MAPPER_ERROR_IF_INVALID_DOC = "Throw an error if the mapped field is missing or invalid. Defaults to false. Requires the 'namespace.mapper' to be set to 'com.mongodb.kafka.connect.sink.topic.mapping.FieldPathNamespaceMapper'.";
    private static final boolean FIELD_NAMESPACE_MAPPER_ERROR_IF_INVALID_DEFAULT = false;
    public static final String DELETE_ON_NULL_VALUES_CONFIG = "delete.on.null.values";
    private static final String DELETE_ON_NULL_VALUES_DISPLAY = "Delete on null values";
    private static final String DELETE_ON_NULL_VALUES_DOC = "Whether or not the connector tries to delete documents based on key when value is null";
    static final boolean DELETE_ON_NULL_VALUES_DEFAULT = false;
    public static final String WRITEMODEL_STRATEGY_CONFIG = "writemodel.strategy";
    private static final String WRITEMODEL_STRATEGY_DISPLAY = "The writeModel strategy";
    private static final String WRITEMODEL_STRATEGY_DOC = "The class the handles how build the write models for the sink documents";
    static final String WRITEMODEL_STRATEGY_DEFAULT = "com.mongodb.kafka.connect.sink.writemodel.strategy.DefaultWriteModelStrategy";
    public static final String MAX_BATCH_SIZE_CONFIG = "max.batch.size";
    private static final String MAX_BATCH_SIZE_DISPLAY = "The maximum batch size";
    private static final String MAX_BATCH_SIZE_DOC = "The maximum number of sink records to possibly batch together for processing";
    private static final int MAX_BATCH_SIZE_DEFAULT = 0;
    public static final String BULK_WRITE_ORDERED_CONFIG = "bulk.write.ordered";
    private static final String BULK_WRITE_ORDERED_DISPLAY = "Use ordered bulk writes";
    private static final String BULK_WRITE_ORDERED_DOC = "Whether the batches controlled by 'max.batch.size' must be written via ordered bulk writes";
    static final boolean BULK_WRITE_ORDERED_DEFAULT = true;
    public static final String RATE_LIMITING_TIMEOUT_CONFIG = "rate.limiting.timeout";
    private static final String RATE_LIMITING_TIMEOUT_DISPLAY = "The rate limiting timeout";
    private static final String RATE_LIMITING_TIMEOUT_DOC = "How long in ms processing should wait before continue processing";
    private static final int RATE_LIMITING_TIMEOUT_DEFAULT = 0;
    public static final String RATE_LIMITING_EVERY_N_CONFIG = "rate.limiting.every.n";
    private static final String RATE_LIMITING_EVERY_N_DISPLAY = "The rate limiting batch number";
    private static final String RATE_LIMITING_EVERY_N_DOC = "After how many processed batches the rate limit should trigger (NO rate limiting if n=0)";
    private static final int RATE_LIMITING_EVERY_N_DEFAULT = 0;
    public static final String POST_PROCESSOR_CHAIN_CONFIG = "post.processor.chain";
    private static final String POST_PROCESSOR_CHAIN_DISPLAY = "The post processor chain";
    private static final String POST_PROCESSOR_CHAIN_DOC = "A comma separated list of post processor classes to process the data before saving to MongoDB.";
    private static final String POST_PROCESSOR_CHAIN_DEFAULT = "com.mongodb.kafka.connect.sink.processor.DocumentIdAdder";
    public static final String KEY_PROJECTION_TYPE_CONFIG = "key.projection.type";
    private static final String KEY_PROJECTION_TYPE_DISPLAY = "The key projection type";
    private static final String KEY_PROJECTION_TYPE_DOC = "The type of key projection to use Use either `AllowList` or `BlockList`.";
    static final String KEY_PROJECTION_TYPE_DEFAULT = "none";
    public static final String KEY_PROJECTION_LIST_CONFIG = "key.projection.list";
    private static final String KEY_PROJECTION_LIST_DISPLAY = "The key projection list";
    private static final String KEY_PROJECTION_LIST_DOC = "A comma separated list of field names for key projection";
    static final String KEY_PROJECTION_LIST_DEFAULT = "";
    public static final String VALUE_PROJECTION_TYPE_CONFIG = "value.projection.type";
    private static final String VALUE_PROJECTION_TYPE_DISPLAY = "The type of value projection to use Use either `AllowList` or `BlockList`.";
    private static final String VALUE_PROJECTION_TYPE_DOC = "The type of value projection to use";
    static final String VALUE_PROJECTION_TYPE_DEFAULT = "none";
    public static final String VALUE_PROJECTION_LIST_CONFIG = "value.projection.list";
    private static final String VALUE_PROJECTION_LIST_DISPLAY = "The value projection list";
    private static final String VALUE_PROJECTION_LIST_DOC = "A comma separated list of field names for value projection";
    static final String VALUE_PROJECTION_LIST_DEFAULT = "";
    public static final String FIELD_RENAMER_MAPPING_CONFIG = "field.renamer.mapping";
    private static final String FIELD_RENAMER_MAPPING_DISPLAY = "The field renamer mapping";
    private static final String FIELD_RENAMER_MAPPING_DOC = "An inline JSON array with objects describing field name mappings.\nExample: `[{\"oldName\":\"key.fieldA\",\"newName\":\"field1\"},{\"oldName\":\"value.xyz\",\"newName\":\"abc\"}]`";
    static final String FIELD_RENAMER_MAPPING_DEFAULT = "[]";
    public static final String FIELD_RENAMER_REGEXP_CONFIG = "field.renamer.regexp";
    public static final String FIELD_RENAMER_REGEXP_DISPLAY = "The field renamer regex";
    private static final String FIELD_RENAMER_REGEXP_DOC = "An inline JSON array with objects describing regexp settings.\nExample: `[{\"regexp\":\"^key\\\\\\\\..*my.*$\",\"pattern\":\"my\",\"replace\":\"\"},{\"regexp\":\"^value\\\\\\\\..*$\",\"pattern\":\"\\\\\\\\.\",\"replace\":\"_\"}]`";
    static final String FIELD_RENAMER_REGEXP_DEFAULT = "[]";
    public static final String DOCUMENT_ID_STRATEGY_CONFIG = "document.id.strategy";
    private static final String DOCUMENT_ID_STRATEGY_DISPLAY = "The document id strategy";
    private static final String DOCUMENT_ID_STRATEGY_DOC = "The IdStrategy class name to use for generating a unique document id (_id)";
    static final String DOCUMENT_ID_STRATEGY_DEFAULT = "com.mongodb.kafka.connect.sink.processor.id.strategy.BsonOidStrategy";
    public static final String DOCUMENT_ID_STRATEGY_OVERWRITE_EXISTING_CONFIG = "document.id.strategy.overwrite.existing";
    private static final String DOCUMENT_ID_STRATEGY_OVERWRITE_EXISTING_DISPLAY = "The document id strategy overwrite existing setting";
    private static final String DOCUMENT_ID_STRATEGY_OVERWRITE_EXISTING_DOC = "Allows the document id strategy will overwrite existing `_id` values";
    static final boolean DOCUMENT_ID_STRATEGY_OVERWRITE_EXISTING_DEFAULT = false;
    public static final String DOCUMENT_ID_STRATEGY_UUID_FORMAT_CONFIG = "document.id.strategy.uuid.format";
    private static final String DOCUMENT_ID_STRATEGY_UUID_FORMAT_DISPLAY = "The document id strategy uuid format";
    private static final String DOCUMENT_ID_STRATEGY_UUID_FORMAT_DOC = "The bson output format when using the `UuidStrategy`. Either `String` or `Binary`.";
    private static final String DOCUMENT_ID_STRATEGY_UUID_FORMAT_DEFAULT = "string";
    public static final String DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_TYPE_CONFIG = "document.id.strategy.partial.key.projection.type";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_TYPE_DISPLAY = "The document id strategy key projection";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_TYPE_DOC = "For use with the `PartialKeyStrategy` allows custom key fields to be projected for the id strategy Use either `AllowList` or `BlockList`.";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_TYPE_DEFAULT = "";
    public static final String DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_LIST_CONFIG = "document.id.strategy.partial.key.projection.list";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_LIST_DISPLAY = "The document id strategy key projection list";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_LIST_DOC = "For use with the `PartialKeyStrategy` allows custom key fields to be projected for the id strategy. A comma separated list of field names for key projection.";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_LIST_DEFAULT = "";
    public static final String DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_TYPE_CONFIG = "document.id.strategy.partial.value.projection.type";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_TYPE_DISPLAY = "The document id strategy value projection";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_TYPE_DOC = "For use with the `PartialValueStrategy` allows custom value fields to be projected for the id strategy. Use either `AllowList` or `BlockList`.";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_TYPE_DEFAULT = "";
    public static final String DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_LIST_CONFIG = "document.id.strategy.partial.value.projection.list";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_LIST_DISPLAY = "The document id strategy value projection list";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_LIST_DOC = "For use with the `PartialValueStrategy` allows custom value fields to be projected for the id strategy. A comma separated list of field names for value projection.";
    private static final String DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_LIST_DEFAULT = "";
    public static final String ERRORS_TOLERANCE_CONFIG = "errors.tolerance";
    public static final String ERRORS_TOLERANCE_DISPLAY = "Error Tolerance";
    public static final ErrorTolerance ERRORS_TOLERANCE_DEFAULT = ErrorTolerance.NONE;
    public static final String ERRORS_TOLERANCE_DOC = "Behavior for tolerating errors during connector operation. 'none' is the default value and signals that any error will result in an immediate connector task failure; 'all' changes the behavior to skip over problematic records.";
    public static final String OVERRIDE_ERRORS_TOLERANCE_CONFIG = "mongo.errors.tolerance";
    public static final String OVERRIDE_ERRORS_TOLERANCE_DOC = "Use this property if you would like to configure the connector's error handling behavior differently from the Connect framework's.";
    public static final String ERRORS_LOG_ENABLE_CONFIG = "errors.log.enable";
    public static final String ERRORS_LOG_ENABLE_DISPLAY = "Log Errors";
    public static final boolean ERRORS_LOG_ENABLE_DEFAULT = false;
    public static final String ERRORS_LOG_ENABLE_DOC = "If true, write each error and the details of the failed operation and problematic record to the Connect application log. This is 'false' by default, so that only errors that are not tolerated are reported.";
    public static final String OVERRIDE_ERRORS_LOG_ENABLE_CONFIG = "mongo.errors.log.enable";
    public static final String OVERRIDE_ERRORS_LOG_ENABLE_DOC = "Use this property if you would like to configure the connector's error handling behavior differently from the mapping Connect framework's.";
    public static final String CHANGE_DATA_CAPTURE_HANDLER_CONFIG = "change.data.capture.handler";
    private static final String CHANGE_DATA_CAPTURE_HANDLER_DISPLAY = "The CDC handler";
    private static final String CHANGE_DATA_CAPTURE_HANDLER_DOC = "The class name of the CDC handler to use for processing";
    static final String CHANGE_DATA_CAPTURE_HANDLER_DEFAULT = "";
    public static final String TIMESERIES_TIMEFIELD_CONFIG = "timeseries.timefield";
    private static final String TIMESERIES_TIMEFIELD_DISPLAY = "The field used for time";
    private static final String TIMESERIES_TIMEFIELD_DOC = "Name of the top level field used for time. Note: Inserted documents must have this field, and the field must be of the BSON datetime type.";
    private static final String TIMESERIES_TIMEFIELD_DEFAULT = "";
    public static final String TIMESERIES_METAFIELD_CONFIG = "timeseries.metafield";
    private static final String TIMESERIES_METAFIELD_DISPLAY = "The field describing the series";
    private static final String TIMESERIES_METAFIELD_DOC = "The name of the top-level field which contains metadata in each time series document. The metadata in the specified field should be data that is used to label a unique series of documents. The metadata should rarely, if ever, change. Note: This field is used to group related data and may be of any BSON type, except for array. The meta field may not be the same as the `timeField` or `_id`.";
    public static final String TIMESERIES_METAFIELD_DEFAULT = "";
    public static final String TIMESERIES_EXPIRE_AFTER_SECONDS_CONFIG = "timeseries.expire.after.seconds";
    private static final String TIMESERIES_EXPIRE_AFTER_SECONDS_DISPLAY = "The data expiry time in seconds";
    private static final String TIMESERIES_EXPIRE_AFTER_SECONDS_DOC = "Determines the amount of time in seconds the data will be in MongoDB before being automatically deleted.";
    public static final int TIMESERIES_EXPIRE_AFTER_SECONDS_DEFAULT = 0;
    public static final String TIMESERIES_GRANULARITY_CONFIG = "timeseries.granularity";
    private static final String TIMESERIES_GRANULARITY_DISPLAY = "The data expiry time";
    private static final String TIMESERIES_GRANULARITY_DOC = "Describes the expected interval between subsequent measurements for a time series. Possible values: \"seconds\" \"minutes\" \"hours\".";
    public static final String TIMESERIES_TIMEFIELD_AUTO_CONVERSION_CONFIG = "timeseries.timefield.auto.convert";
    private static final String TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DISPLAY = "Convert the field to a BSON datetime type.";
    private static final String TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DOC = "Converts the timeseries field to a BSON datetime type. If the value is a numeric value it will use it as the milliseconds from epoch. Note any fractional parts are discarded. If the value is a String it will use `timeseries.timefield.auto.convert.date.format` configuration to parse the date.";
    public static final String TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DATE_FORMAT_CONFIG = "timeseries.timefield.auto.convert.date.format";
    private static final String TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DATE_FORMAT_DISPLAY = "The DateTimeFormatter pattern for the date.";
    private static final String TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DATE_FORMAT_DOC = "The DateTimeFormatter pattern to use when converting String dates. Defaults to supporting ISO style date times. Note: A string representation is expected to contain both date and time information. If the string only contains date information then the time since epoch will be taken from the start of that day. If a string representation does not contain time-zone offset, then the extracted date and time is interpreted as UTC.";
    private static final String TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DATE_FORMAT_DEFAULT = FlexibleDateTimeParser.DEFAULT_DATE_TIME_FORMATTER_PATTERN;
    public static final String TIMESERIES_TIMEFIELD_AUTO_CONVERSION_LOCALE_LANGUAGE_TAG_CONFIG = "timeseries.timefield.auto.convert.locale.language.tag";
    private static final String TIMESERIES_TIMEFIELD_AUTO_CONVERSION_LOCALE_LANGUAGE_TAG_DISPLAY = "The DateTimeFormatter locale language tag to use: Defaults to using the neutral Locale.ROOT.";
    private static final String TIMESERIES_TIMEFIELD_AUTO_CONVERSION_LOCALE_LANGUAGE_TAG_DOC = "The DateTimeFormatter locale language tag to use with the date pattern: Defaults to Locale.ROOT.";
    private static final Pattern CLASS_NAME = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    public static final Pattern FULLY_QUALIFIED_CLASS_NAME = Pattern.compile("(" + CLASS_NAME + "\\.)*" + CLASS_NAME);
    public static final String ID_FIELD = "_id";
    static final List<String> SYNTHETIC_CONFIGS = Collections.singletonList("topic");
    private static final List<Consumer<MongoSinkTopicConfig>> INITIALIZERS = Arrays.asList(MongoSinkTopicConfig::getNamespaceMapper, MongoSinkTopicConfig::getIdStrategy, MongoSinkTopicConfig::getPostProcessors, MongoSinkTopicConfig::getWriteModelStrategy, MongoSinkTopicConfig::getDeleteOneWriteModelStrategy, MongoSinkTopicConfig::getRateLimitSettings, MongoSinkTopicConfig::getCdcHandler);
    private final String topic;
    private NamespaceMapper namespaceMapper;
    private IdStrategy idStrategy;
    private PostProcessors postProcessors;
    private WriteModelStrategy writeModelStrategy;
    private WriteModelStrategy deleteOneWriteModelStrategy;
    private RateLimitSettings rateLimitSettings;
    private CdcHandler cdcHandler;
    static final ConfigDef BASE_CONFIG = MongoSinkTopicConfig.createConfigDef();
    static final ConfigDef CONFIG = MongoSinkTopicConfig.createConfigDef().define("topic", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, "Topic name");

    MongoSinkTopicConfig(String topic, Map<String, String> originals) {
        this(topic, originals, true);
    }

    public MongoSinkTopicConfig(String topic, Map<String, String> originals, boolean initializeAll) {
        super(CONFIG, MongoSinkTopicConfig.createSinkTopicOriginals(topic, originals));
        this.topic = topic;
        if (initializeAll) {
            INITIALIZERS.forEach(i -> i.accept(this));
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean logErrors() {
        return !this.tolerateErrors() || ConfigHelper.getOverrideOrFallback(this, AbstractConfig::getBoolean, OVERRIDE_ERRORS_LOG_ENABLE_CONFIG, ERRORS_LOG_ENABLE_CONFIG) != false;
    }

    public boolean tolerateErrors() {
        String errorsTolerance = ConfigHelper.getOverrideOrFallback(this, AbstractConfig::getString, OVERRIDE_ERRORS_TOLERANCE_CONFIG, ERRORS_TOLERANCE_CONFIG);
        return ErrorTolerance.valueOf(errorsTolerance.toUpperCase()).equals((Object)ErrorTolerance.ALL);
    }

    public boolean isTimeseries() {
        return !this.getString(TIMESERIES_TIMEFIELD_CONFIG).trim().isEmpty();
    }

    private <T> T configureInstance(T instance) {
        if (instance instanceof Configurable) {
            ((Configurable)instance).configure(this);
        }
        return instance;
    }

    public IdStrategy getIdStrategy() {
        if (this.idStrategy == null) {
            this.idStrategy = this.configureInstance(ClassHelper.createInstance(DOCUMENT_ID_STRATEGY_CONFIG, this.getString(DOCUMENT_ID_STRATEGY_CONFIG), IdStrategy.class));
        }
        return this.idStrategy;
    }

    PostProcessors getPostProcessors() {
        if (this.postProcessors == null) {
            this.postProcessors = new PostProcessors(this, this.getList(POST_PROCESSOR_CHAIN_CONFIG));
        }
        return this.postProcessors;
    }

    public WriteModelStrategy getWriteModelStrategy() {
        if (this.writeModelStrategy == null) {
            this.writeModelStrategy = this.configureInstance(ClassHelper.createInstance(WRITEMODEL_STRATEGY_CONFIG, this.getString(WRITEMODEL_STRATEGY_CONFIG), WriteModelStrategy.class));
        }
        return this.writeModelStrategy;
    }

    public Optional<WriteModelStrategy> getDeleteOneWriteModelStrategy() {
        if (!this.getBoolean(DELETE_ON_NULL_VALUES_CONFIG).booleanValue()) {
            return Optional.empty();
        }
        if (this.deleteOneWriteModelStrategy == null) {
            IdStrategy idStrategy = this.getIdStrategy();
            if (!(idStrategy instanceof FullKeyStrategy || idStrategy instanceof PartialKeyStrategy || idStrategy instanceof ProvidedInKeyStrategy)) {
                throw new ConnectConfigException(DELETE_ON_NULL_VALUES_CONFIG, this.getBoolean(DELETE_ON_NULL_VALUES_CONFIG), String.format("%s can only be applied when the configured IdStrategy is an instance of: %s or %s or %s", DeleteOneDefaultStrategy.class.getSimpleName(), FullKeyStrategy.class.getSimpleName(), PartialKeyStrategy.class.getSimpleName(), ProvidedInKeyStrategy.class.getSimpleName()));
            }
            this.deleteOneWriteModelStrategy = new DeleteOneDefaultStrategy(idStrategy);
        }
        return Optional.of(this.deleteOneWriteModelStrategy);
    }

    Optional<CdcHandler> getCdcHandler() {
        String cdcHandler = this.getString(CHANGE_DATA_CAPTURE_HANDLER_CONFIG);
        if (cdcHandler.isEmpty()) {
            return Optional.empty();
        }
        if (this.cdcHandler == null) {
            this.cdcHandler = ClassHelper.createInstance(CHANGE_DATA_CAPTURE_HANDLER_CONFIG, cdcHandler, CdcHandler.class, () -> (CdcHandler)Class.forName(cdcHandler).getConstructor(MongoSinkTopicConfig.class).newInstance(new Object[]{this}));
        }
        return Optional.of(this.cdcHandler);
    }

    RateLimitSettings getRateLimitSettings() {
        if (this.rateLimitSettings == null) {
            this.rateLimitSettings = new RateLimitSettings(this.getInt(RATE_LIMITING_TIMEOUT_CONFIG), this.getInt(RATE_LIMITING_EVERY_N_CONFIG));
        }
        return this.rateLimitSettings;
    }

    public NamespaceMapper getNamespaceMapper() {
        if (this.namespaceMapper == null) {
            this.namespaceMapper = this.configureInstance(ClassHelper.createInstance(NAMESPACE_MAPPER_CONFIG, this.getString(NAMESPACE_MAPPER_CONFIG), NamespaceMapper.class));
        }
        return this.namespaceMapper;
    }

    static Map<String, ConfigValue> validateAll(String topic, Map<String, String> props) {
        String prefix = String.format("%s%s.", TOPIC_OVERRIDE_PREFIX, topic);
        List topicOverrides = props.keySet().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toList());
        HashMap<String, ConfigValue> results = new HashMap<String, ConfigValue>();
        Map<String, String> sinkTopicOriginals = MongoSinkTopicConfig.createSinkTopicOriginals(topic, props);
        CONFIG.validateAll(sinkTopicOriginals).forEach((k, v) -> {
            String name;
            String string = name = topicOverrides.contains(prefix + k) ? prefix + k : k;
            if (props.containsKey(name) && !SYNTHETIC_CONFIGS.contains(name)) {
                results.put(name, new ConfigValue(name, v.value(), v.recommendedValues(), v.errorMessages()));
            }
        });
        if (results.values().stream().allMatch(v -> v.errorMessages().isEmpty())) {
            MongoSinkTopicConfig cfg = new MongoSinkTopicConfig(topic, sinkTopicOriginals, false);
            INITIALIZERS.forEach(i -> {
                try {
                    i.accept(cfg);
                }
                catch (ConnectConfigException t) {
                    results.put(t.getName(), new ConfigValue(t.getName(), t.getValue(), Collections.emptyList(), Collections.singletonList(t.getMessage())));
                }
            });
        }
        return results;
    }

    private static Map<String, String> createSinkTopicOriginals(String topic, Map<String, String> originals) {
        HashMap<String, String> topicConfig = new HashMap<String, String>();
        HashMap topicOverrides = new HashMap();
        String topicOverridePrefix = String.format("%s%s", TOPIC_OVERRIDE_PREFIX, topic);
        topicConfig.put(TOPIC_CONFIG, topic);
        originals.forEach((k, v) -> {
            if (!(k.startsWith(TOPIC_OVERRIDE_PREFIX) || k.equals("connection.uri") || k.equals("topics"))) {
                topicConfig.put((String)k, (String)v);
            }
            if (k.startsWith(topicOverridePrefix)) {
                topicOverrides.put(k.substring(topicOverridePrefix.length() + 1), v);
            }
        });
        topicConfig.putAll(topicOverrides);
        return topicConfig;
    }

    static Map<String, ConfigValue> validateRegexAll(Map<String, String> props) {
        HashMap<String, ConfigValue> results = new HashMap<String, ConfigValue>();
        Map<String, String> sinkTopicOriginals = MongoSinkTopicConfig.createSinkTopicOriginals(props);
        BASE_CONFIG.validateAll(sinkTopicOriginals).forEach((k, v) -> {
            if (!SYNTHETIC_CONFIGS.contains(k)) {
                results.put((String)k, new ConfigValue(k, v.value(), v.recommendedValues(), v.errorMessages()));
            }
        });
        if (props.keySet().stream().anyMatch(k -> k.startsWith(TOPIC_OVERRIDE_PREFIX))) {
            props.keySet().stream().filter(k -> k.startsWith(TOPIC_OVERRIDE_PREFIX)).map(k -> k.substring(TOPIC_OVERRIDE_PREFIX.length()).split("\\.")[0]).forEach(t -> results.putAll(MongoSinkTopicConfig.validateAll(t, props)));
        } else {
            results.putAll(MongoSinkTopicConfig.validateAll("test", props));
        }
        return results;
    }

    private static Map<String, String> createSinkTopicOriginals(Map<String, String> originals) {
        HashMap<String, String> topicConfig = new HashMap<String, String>();
        originals.forEach((k, v) -> {
            if (!(k.startsWith(TOPIC_OVERRIDE_PREFIX) || k.equals("connection.uri") || k.equals("topics"))) {
                topicConfig.put((String)k, (String)v);
            }
        });
        return topicConfig;
    }

    private static ConfigDef createConfigDef() {
        ConfigDef configDef = new ConfigDef();
        String group = "Namespace";
        int orderInGroup = 0;
        configDef.define(DATABASE_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.HIGH, DATABASE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DATABASE_DISPLAY);
        configDef.define(COLLECTION_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, COLLECTION_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, COLLECTION_DISPLAY);
        group = "Namespace mapping";
        orderInGroup = 0;
        configDef.define(NAMESPACE_MAPPER_CONFIG, ConfigDef.Type.STRING, (Object)NAMESPACE_MAPPER_DEFAULT, (ConfigDef.Validator)Validators.matching(FULLY_QUALIFIED_CLASS_NAME), ConfigDef.Importance.HIGH, NAMESPACE_MAPPER_DOC, group, ++orderInGroup, ConfigDef.Width.LONG, NAMESPACE_MAPPER_DISPLAY);
        configDef.define(FIELD_KEY_DATABASE_NAMESPACE_MAPPER_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, FIELD_KEY_DATABASE_NAMESPACE_MAPPER_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, FIELD_KEY_DATABASE_NAMESPACE_MAPPER_DISPLAY);
        configDef.define(FIELD_KEY_COLLECTION_NAMESPACE_MAPPER_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, FIELD_KEY_COLLECTION_NAMESPACE_MAPPER_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, FIELD_KEY_COLLECTION_NAMESPACE_MAPPER_DISPLAY);
        configDef.define(FIELD_VALUE_DATABASE_NAMESPACE_MAPPER_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, FIELD_VALUE_DATABASE_NAMESPACE_MAPPER_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, FIELD_VALUE_DATABASE_NAMESPACE_MAPPER_DISPLAY);
        configDef.define(FIELD_VALUE_COLLECTION_NAMESPACE_MAPPER_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, FIELD_VALUE_COLLECTION_NAMESPACE_MAPPER_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, FIELD_VALUE_COLLECTION_NAMESPACE_MAPPER_DISPLAY);
        configDef.define(FIELD_NAMESPACE_MAPPER_ERROR_IF_INVALID_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, FIELD_NAMESPACE_MAPPER_ERROR_IF_INVALID_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, FIELD_NAMESPACE_MAPPER_ERROR_IF_INVALID_DISPLAY);
        group = "Writes";
        orderInGroup = 0;
        configDef.define(DELETE_ON_NULL_VALUES_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, DELETE_ON_NULL_VALUES_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DELETE_ON_NULL_VALUES_DISPLAY);
        configDef.define(WRITEMODEL_STRATEGY_CONFIG, ConfigDef.Type.STRING, (Object)WRITEMODEL_STRATEGY_DEFAULT, (ConfigDef.Validator)Validators.matching(FULLY_QUALIFIED_CLASS_NAME), ConfigDef.Importance.LOW, WRITEMODEL_STRATEGY_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, WRITEMODEL_STRATEGY_DISPLAY);
        configDef.define(MAX_BATCH_SIZE_CONFIG, ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_BATCH_SIZE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, MAX_BATCH_SIZE_DISPLAY);
        configDef.define(BULK_WRITE_ORDERED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, BULK_WRITE_ORDERED_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, BULK_WRITE_ORDERED_DISPLAY);
        configDef.define(RATE_LIMITING_TIMEOUT_CONFIG, ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, RATE_LIMITING_TIMEOUT_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, RATE_LIMITING_TIMEOUT_DISPLAY);
        configDef.define(RATE_LIMITING_EVERY_N_CONFIG, ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, RATE_LIMITING_EVERY_N_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, RATE_LIMITING_EVERY_N_DISPLAY);
        group = "Post Processing";
        orderInGroup = 0;
        configDef.define(POST_PROCESSOR_CHAIN_CONFIG, ConfigDef.Type.LIST, (Object)POST_PROCESSOR_CHAIN_DEFAULT, (ConfigDef.Validator)Validators.listMatchingPattern(FULLY_QUALIFIED_CLASS_NAME), ConfigDef.Importance.LOW, POST_PROCESSOR_CHAIN_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, POST_PROCESSOR_CHAIN_DISPLAY);
        configDef.define(KEY_PROJECTION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"none", (ConfigDef.Validator)Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values()), ConfigDef.Importance.LOW, KEY_PROJECTION_TYPE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, KEY_PROJECTION_TYPE_DISPLAY, (ConfigDef.Recommender)Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values()));
        configDef.define(KEY_PROJECTION_LIST_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, KEY_PROJECTION_LIST_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, KEY_PROJECTION_LIST_DISPLAY, Collections.singletonList(KEY_PROJECTION_TYPE_CONFIG));
        configDef.define(VALUE_PROJECTION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"none", (ConfigDef.Validator)Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values()), ConfigDef.Importance.LOW, VALUE_PROJECTION_TYPE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, VALUE_PROJECTION_TYPE_DISPLAY, (ConfigDef.Recommender)Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values()));
        configDef.define(VALUE_PROJECTION_LIST_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, VALUE_PROJECTION_LIST_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, VALUE_PROJECTION_LIST_DISPLAY, Collections.singletonList(VALUE_PROJECTION_TYPE_CONFIG));
        configDef.define(FIELD_RENAMER_MAPPING_CONFIG, ConfigDef.Type.STRING, (Object)"[]", (ConfigDef.Validator)Validators.errorCheckingValueValidator("A valid JSON array", ConfigHelper::jsonArrayFromString), ConfigDef.Importance.LOW, FIELD_RENAMER_MAPPING_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, FIELD_RENAMER_MAPPING_DISPLAY);
        configDef.define(FIELD_RENAMER_REGEXP_CONFIG, ConfigDef.Type.STRING, (Object)"[]", (ConfigDef.Validator)Validators.errorCheckingValueValidator("A valid JSON array", ConfigHelper::jsonArrayFromString), ConfigDef.Importance.LOW, FIELD_RENAMER_REGEXP_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, FIELD_RENAMER_REGEXP_DISPLAY);
        group = "Id Strategies";
        orderInGroup = 0;
        configDef.define(DOCUMENT_ID_STRATEGY_CONFIG, ConfigDef.Type.STRING, (Object)DOCUMENT_ID_STRATEGY_DEFAULT, (ConfigDef.Validator)Validators.emptyString().or(Validators.matching(FULLY_QUALIFIED_CLASS_NAME)), ConfigDef.Importance.HIGH, DOCUMENT_ID_STRATEGY_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DOCUMENT_ID_STRATEGY_DISPLAY);
        configDef.define(DOCUMENT_ID_STRATEGY_OVERWRITE_EXISTING_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, DOCUMENT_ID_STRATEGY_OVERWRITE_EXISTING_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DOCUMENT_ID_STRATEGY_OVERWRITE_EXISTING_DISPLAY);
        configDef.define(DOCUMENT_ID_STRATEGY_UUID_FORMAT_CONFIG, ConfigDef.Type.STRING, (Object)DOCUMENT_ID_STRATEGY_UUID_FORMAT_DEFAULT, (ConfigDef.Validator)Validators.EnumValidatorAndRecommender.in(UuidBsonFormat.values()), ConfigDef.Importance.HIGH, DOCUMENT_ID_STRATEGY_UUID_FORMAT_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DOCUMENT_ID_STRATEGY_UUID_FORMAT_DISPLAY, (ConfigDef.Recommender)Validators.EnumValidatorAndRecommender.in(UuidBsonFormat.values()));
        configDef.define(DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)Validators.emptyString().or(Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values())), ConfigDef.Importance.LOW, DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_TYPE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_TYPE_DISPLAY, (ConfigDef.Recommender)Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values()));
        configDef.define(DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_LIST_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_LIST_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_LIST_DISPLAY, Collections.singletonList(DOCUMENT_ID_STRATEGY_PARTIAL_KEY_PROJECTION_TYPE_CONFIG));
        configDef.define(DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)Validators.emptyString().or(Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values())), ConfigDef.Importance.LOW, DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_TYPE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_TYPE_DISPLAY, (ConfigDef.Recommender)Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values()));
        configDef.define(DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_LIST_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_LIST_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_LIST_DISPLAY, Collections.singletonList(DOCUMENT_ID_STRATEGY_PARTIAL_VALUE_PROJECTION_TYPE_CONFIG));
        group = "Errors";
        orderInGroup = 0;
        configDef.define(ERRORS_TOLERANCE_CONFIG, ConfigDef.Type.STRING, (Object)ERRORS_TOLERANCE_DEFAULT.value(), (ConfigDef.Validator)Validators.EnumValidatorAndRecommender.in(ErrorTolerance.values()), ConfigDef.Importance.MEDIUM, ERRORS_TOLERANCE_DOC, group, ++orderInGroup, ConfigDef.Width.SHORT, ERRORS_TOLERANCE_DISPLAY);
        configDef.define(OVERRIDE_ERRORS_TOLERANCE_CONFIG, ConfigDef.Type.STRING, (Object)ERRORS_TOLERANCE_DEFAULT.value(), (ConfigDef.Validator)Validators.EnumValidatorAndRecommender.in(ErrorTolerance.values()), ConfigDef.Importance.MEDIUM, OVERRIDE_ERRORS_TOLERANCE_DOC, group, ++orderInGroup, ConfigDef.Width.SHORT, ERRORS_TOLERANCE_DISPLAY);
        configDef.define(ERRORS_LOG_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, ERRORS_LOG_ENABLE_DOC, group, ++orderInGroup, ConfigDef.Width.SHORT, ERRORS_LOG_ENABLE_DISPLAY);
        configDef.define(OVERRIDE_ERRORS_LOG_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, OVERRIDE_ERRORS_LOG_ENABLE_DOC, group, ++orderInGroup, ConfigDef.Width.SHORT, ERRORS_LOG_ENABLE_DISPLAY);
        group = "Change Data Capture";
        orderInGroup = 0;
        configDef.define(CHANGE_DATA_CAPTURE_HANDLER_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)Validators.emptyString().or(Validators.matching(FULLY_QUALIFIED_CLASS_NAME)), ConfigDef.Importance.LOW, CHANGE_DATA_CAPTURE_HANDLER_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, CHANGE_DATA_CAPTURE_HANDLER_DISPLAY);
        group = "Time series";
        orderInGroup = 0;
        configDef.define(TIMESERIES_TIMEFIELD_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, TIMESERIES_TIMEFIELD_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TIMESERIES_TIMEFIELD_DISPLAY);
        configDef.define(TIMESERIES_METAFIELD_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, TIMESERIES_METAFIELD_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TIMESERIES_METAFIELD_DISPLAY);
        configDef.define(TIMESERIES_EXPIRE_AFTER_SECONDS_CONFIG, ConfigDef.Type.LONG, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, TIMESERIES_EXPIRE_AFTER_SECONDS_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TIMESERIES_EXPIRE_AFTER_SECONDS_DISPLAY);
        configDef.define(TIMESERIES_GRANULARITY_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)Validators.emptyString().or(Validators.EnumValidatorAndRecommender.in(TimeSeriesGranularity.values())), ConfigDef.Importance.LOW, TIMESERIES_GRANULARITY_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TIMESERIES_GRANULARITY_DISPLAY);
        configDef.define(TIMESERIES_TIMEFIELD_AUTO_CONVERSION_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DISPLAY);
        configDef.define(TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DATE_FORMAT_CONFIG, ConfigDef.Type.STRING, (Object)TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DATE_FORMAT_DEFAULT, (ConfigDef.Validator)Validators.errorCheckingValueValidator("A valid DateTimeFormatter format", DateTimeFormatter::ofPattern), ConfigDef.Importance.LOW, TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DATE_FORMAT_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TIMESERIES_TIMEFIELD_AUTO_CONVERSION_DATE_FORMAT_DISPLAY);
        configDef.define(TIMESERIES_TIMEFIELD_AUTO_CONVERSION_LOCALE_LANGUAGE_TAG_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)Validators.emptyString().or(Validators.errorCheckingValueValidator("A valid Locale language tag format", Locale::forLanguageTag)), ConfigDef.Importance.LOW, TIMESERIES_TIMEFIELD_AUTO_CONVERSION_LOCALE_LANGUAGE_TAG_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TIMESERIES_TIMEFIELD_AUTO_CONVERSION_LOCALE_LANGUAGE_TAG_DISPLAY);
        return configDef;
    }

    public static enum ErrorTolerance {
        NONE,
        ALL;


        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum FieldProjectionType {
        NONE,
        BLACKLIST,
        WHITELIST,
        ALLOWLIST,
        BLOCKLIST;

    }

    public static enum UuidBsonFormat {
        STRING,
        BINARY;

    }
}

