/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink;

import com.mongodb.annotations.Immutable;
import com.mongodb.kafka.connect.sink.MongoSinkConfig;
import com.mongodb.kafka.connect.util.Assertions;
import com.mongodb.lang.Nullable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SinkConfigSoftValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoSinkConfig.class);
    static final Set<String> OBSOLETE_CONFIGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("max.num.retries", "retries.defer.timeout")));
    private static final Set<IncompatiblePropertiesPair> INCOMPATIBLE_CONFIGS = Collections.unmodifiableSet(new HashSet<IncompatiblePropertiesPair>(Arrays.asList(IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "post.processor.chain", null), IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "field.renamer.mapping", "[]"), IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "field.renamer.regexp", "[]"), IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "key.projection.list", ""), IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "key.projection.type", "none"), IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "value.projection.list", ""), IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "value.projection.type", "none"), IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "writemodel.strategy", null), IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "document.id.strategy", null), IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "document.id.strategy.overwrite.existing", String.valueOf(false)), IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "document.id.strategy.uuid.format", null), IncompatiblePropertiesPair.latterIgnored("change.data.capture.handler", "", "delete.on.null.values", String.valueOf(false)))));

    static void logObsoleteProperties(Collection<String> propertyNames) {
        propertyNames.stream().filter(propertyName -> OBSOLETE_CONFIGS.contains(SinkConfigSoftValidator.strippedPropertyName(propertyName))).forEach(obsoletePropertyName -> LOGGER.warn("The configuration property '{}' is obsolete because the sink connector started to rely on retries in the MongoDB Java driver. Remove it as it has no effect. If you have 'retryWrites=false' specified in the '{}' configuration property, then retries are disabled for the sink connector; remove 'retryWrites=false' from '{}' if you want to enable retries.", new Object[]{obsoletePropertyName, "connection.uri", "connection.uri"}));
    }

    static void logIncompatibleProperties(Map<String, String> props) {
        SinkConfigSoftValidator.logIncompatibleProperties(props, arg_0 -> ((Logger)LOGGER).warn(arg_0));
    }

    static void logIncompatibleProperties(Map<String, String> props, Consumer<String> logger) {
        String global = "";
        Map<String, Map<String, String>> topicNameToItsStrippedProps = props.entrySet().stream().collect(Collectors.groupingBy(propNameAndValue -> SinkConfigSoftValidator.topicNameFromPropertyName((String)propNameAndValue.getKey()), Collectors.mapping(Function.identity(), Collectors.toMap(propNameAndValue -> SinkConfigSoftValidator.strippedPropertyName((String)propNameAndValue.getKey()), Map.Entry::getValue))));
        Map<String, String> globalProps = topicNameToItsStrippedProps.getOrDefault(global, Collections.emptyMap());
        topicNameToItsStrippedProps.remove(global);
        Map<String, Map> topicNameToCombinedStrippedProps = topicNameToItsStrippedProps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, topicNameAndItsStrippedProps -> SinkConfigSoftValidator.combineProperties(globalProps, (String)topicNameAndItsStrippedProps.getKey(), (Map)topicNameAndItsStrippedProps.getValue())));
        Map<String, Map.Entry<String, Boolean>> globalPropsWithFalseFlags = SinkConfigSoftValidator.combineProperties(globalProps, null, null);
        INCOMPATIBLE_CONFIGS.forEach(incompatiblePair -> {
            incompatiblePair.logIfPresent(null, globalPropsWithFalseFlags, logger);
            topicNameToCombinedStrippedProps.forEach((topicName, combinedStrippedProps) -> incompatiblePair.logIfPresent(topicName.equals(global) ? null : topicName, (Map<String, Map.Entry<String, Boolean>>)combinedStrippedProps, logger));
        });
    }

    private static Map<String, Map.Entry<String, Boolean>> combineProperties(Map<String, String> globalProps, @Nullable String topicName, @Nullable Map<String, String> topicStrippedProps) {
        Assertions.assertTrue(topicName == null ^ topicStrippedProps != null);
        HashMap<String, Map.Entry<String, Boolean>> combinedStrippedProps = new HashMap<String, Map.Entry<String, Boolean>>();
        globalProps.forEach((propertyName, propertyValue) -> combinedStrippedProps.put((String)propertyName, (Map.Entry<String, Boolean>)new AbstractMap.SimpleImmutableEntry<String, Boolean>((String)propertyValue, false)));
        if (topicStrippedProps != null) {
            topicStrippedProps.forEach((propertyName, propertyValue) -> combinedStrippedProps.put((String)propertyName, (Map.Entry<String, Boolean>)new AbstractMap.SimpleImmutableEntry<String, Boolean>((String)propertyValue, true)));
        }
        return combinedStrippedProps;
    }

    private static String strippedPropertyName(String propertyName) {
        return propertyName.startsWith("topic.override.") ? propertyName.substring(propertyName.indexOf(".", "topic.override.".length() + 1) + 1) : propertyName;
    }

    private static String overriddenPropertyName(String topicName, String strippedPropertyName) {
        return "topic.override." + topicName + "." + strippedPropertyName;
    }

    private static String topicNameFromPropertyName(String propertyName) {
        if (propertyName.startsWith("topic.override.")) {
            int topicNameStartIdx = "topic.override.".length();
            return propertyName.substring(topicNameStartIdx, propertyName.indexOf(".", topicNameStartIdx));
        }
        return "";
    }

    private SinkConfigSoftValidator() {
    }

    @Immutable
    private static final class IncompatiblePropertiesPair {
        private final String propertyName1;
        private final String defaultPropertyValue1;
        private final String propertyName2;
        private final String defaultPropertyValue2;
        private final String msg;

        private IncompatiblePropertiesPair(String propertyName1, @Nullable String defaultPropertyValue1, String propertyName2, @Nullable String defaultPropertyValue2, @Nullable String msg) {
            this.propertyName1 = propertyName1;
            this.defaultPropertyValue1 = defaultPropertyValue1;
            this.propertyName2 = propertyName2;
            this.defaultPropertyValue2 = defaultPropertyValue2;
            this.msg = msg == null ? "" : " " + msg;
        }

        static IncompatiblePropertiesPair latterIgnored(String propertyName1, @Nullable String defaultPropertyValue1, String propertyName2, @Nullable String defaultPropertyValue2) {
            return new IncompatiblePropertiesPair(propertyName1, defaultPropertyValue1, propertyName2, defaultPropertyValue2, "The latter is ignored.");
        }

        void logIfPresent(@Nullable String topicName, Map<String, Map.Entry<String, Boolean>> combinedStrippedProps, Consumer<String> logger) {
            Map.Entry<String, Boolean> property1ValueAndOverridden = combinedStrippedProps.get(this.propertyName1);
            if (property1ValueAndOverridden == null || property1ValueAndOverridden.getKey().equals(this.defaultPropertyValue1)) {
                return;
            }
            Map.Entry<String, Boolean> property2ValueAndOverridden = combinedStrippedProps.get(this.propertyName2);
            if (property2ValueAndOverridden == null || property2ValueAndOverridden.getKey().equals(this.defaultPropertyValue2)) {
                return;
            }
            logger.accept(String.format("Configuration property %s is incompatible with %s.%s", property1ValueAndOverridden.getValue() != false ? SinkConfigSoftValidator.overriddenPropertyName(Assertions.assertNotNull(topicName), this.propertyName1) : this.propertyName1, property2ValueAndOverridden.getValue() != false ? SinkConfigSoftValidator.overriddenPropertyName(Assertions.assertNotNull(topicName), this.propertyName2) : this.propertyName2, this.msg));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IncompatiblePropertiesPair that = (IncompatiblePropertiesPair)o;
            return this.propertyName1.equals(that.propertyName1) && this.propertyName2.equals(that.propertyName2);
        }

        public int hashCode() {
            return this.propertyName1.hashCode() + this.propertyName2.hashCode();
        }

        public String toString() {
            return "IncompatiblePropertiesPair{name1=" + this.propertyName1 + ", name2=" + this.propertyName2 + ", msg=" + this.msg + '}';
        }
    }
}

