/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.field.renaming;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.PostProcessor;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public abstract class Renamer
extends PostProcessor {
    private static final String PATH_PREFIX_KEY = "key";
    private static final String PATH_PREFIX_VALUE = "value";
    static final String SUB_FIELD_DOT_SEPARATOR = ".";

    public Renamer(MongoSinkTopicConfig config) {
        super(config);
    }

    abstract String renamed(String var1, String var2);

    abstract boolean isActive();

    private void doRenaming(String field, BsonDocument doc) {
        BsonDocument modifications = new BsonDocument();
        Iterator iter = doc.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String oldKey = (String)entry.getKey();
            BsonValue value = (BsonValue)entry.getValue();
            String newKey = this.renamed(field, oldKey);
            if (!oldKey.equals(newKey)) {
                doc.computeIfAbsent((Object)newKey, k -> (BsonValue)modifications.putIfAbsent(k, (Object)value));
                iter.remove();
            }
            if (!value.isDocument()) continue;
            String pathToField = field + SUB_FIELD_DOT_SEPARATOR + newKey;
            this.doRenaming(pathToField, value.asDocument());
        }
        doc.putAll((Map)modifications);
    }

    @Override
    public void process(SinkDocument doc, SinkRecord orig) {
        if (this.isActive()) {
            doc.getKeyDoc().ifPresent(kd -> this.doRenaming(PATH_PREFIX_KEY, (BsonDocument)kd));
            doc.getValueDoc().ifPresent(vd -> this.doRenaming(PATH_PREFIX_VALUE, (BsonDocument)vd));
        }
    }
}

