/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.id.strategy;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.AllowListKeyProjector;
import com.mongodb.kafka.connect.sink.processor.BlockListKeyProjector;
import com.mongodb.kafka.connect.sink.processor.field.projection.FieldProjector;
import com.mongodb.kafka.connect.sink.processor.id.strategy.IdStrategy;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ConnectConfigException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class PartialKeyStrategy
implements IdStrategy {
    private FieldProjector fieldProjector;

    @Override
    public BsonValue generateId(SinkDocument doc, SinkRecord orig) {
        SinkDocument clone = doc.clone();
        this.fieldProjector.process(clone, orig);
        return (BsonValue)clone.getKeyDoc().orElseGet(BsonDocument::new);
    }

    public FieldProjector getFieldProjector() {
        return this.fieldProjector;
    }

    @Override
    public void configure(MongoSinkTopicConfig config) {
        MongoSinkTopicConfig.FieldProjectionType keyProjectionType = MongoSinkTopicConfig.FieldProjectionType.valueOf(ConfigHelper.getOverrideOrDefault(config, "document.id.strategy.partial.key.projection.type", "key.projection.type").toUpperCase());
        String fieldList = ConfigHelper.getOverrideOrDefault(config, "document.id.strategy.partial.key.projection.list", "key.projection.list");
        switch (keyProjectionType) {
            case BLACKLIST: 
            case BLOCKLIST: {
                this.fieldProjector = new BlockListKeyProjector(config, fieldList);
                break;
            }
            case ALLOWLIST: 
            case WHITELIST: {
                this.fieldProjector = new AllowListKeyProjector(config, fieldList);
                break;
            }
            default: {
                throw new ConnectConfigException("document.id.strategy", this.getClass().getName(), String.format("Invalid %s value. It should be set to either %s or %s", new Object[]{"key.projection.type", MongoSinkTopicConfig.FieldProjectionType.BLOCKLIST, MongoSinkTopicConfig.FieldProjectionType.ALLOWLIST}));
            }
        }
    }
}

