/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.topic.mapping;

import com.mongodb.kafka.connect.source.MongoSourceConfig;
import com.mongodb.kafka.connect.source.topic.mapping.TopicMapper;
import com.mongodb.kafka.connect.util.BsonDocumentFieldLookup;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ConnectConfigException;
import java.util.HashMap;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.Document;

public class DefaultTopicMapper
implements TopicMapper {
    private static final String DB_FIELD_PATH = "ns.db";
    private static final String COLL_FIELD_PATH = "ns.coll";
    private static final String ALL = "*";
    private static final char NAMESPACE_SEPARATOR = '.';
    private String separator;
    private String prefix;
    private String suffix;
    private Document topicNamespaceMap;
    private Map<String, String> namespaceTopicCache;

    @Override
    public void configure(MongoSourceConfig config) {
        String prefix = config.getString("topic.prefix");
        String suffix = config.getString("topic.suffix");
        this.separator = config.getString("topic.separator");
        this.prefix = prefix.isEmpty() ? prefix : prefix + this.separator;
        this.suffix = suffix.isEmpty() ? suffix : this.separator + suffix;
        this.topicNamespaceMap = ConfigHelper.documentFromString(config.getString("topic.namespace.map")).orElse(new Document());
        if (this.topicNamespaceMap.values().stream().anyMatch(i -> !(i instanceof String))) {
            throw new ConnectConfigException("topic.namespace.map", config.getString("topic.namespace.map"), String.format("All values of `%s` must be strings", "topic.namespace.map"));
        }
        this.namespaceTopicCache = new HashMap<String, String>();
    }

    @Override
    public String getTopic(BsonDocument changeStreamDocument) {
        String dbName = this.getStringFromPath(DB_FIELD_PATH, changeStreamDocument);
        if (dbName.isEmpty()) {
            return dbName;
        }
        String collName = this.getStringFromPath(COLL_FIELD_PATH, changeStreamDocument);
        String namespace = DefaultTopicMapper.namespace(dbName, collName);
        String cachedTopic = this.namespaceTopicCache.get(namespace);
        if (cachedTopic == null) {
            cachedTopic = this.decorateTopicName(this.getUndecoratedTopicNameFromNamespaceMap(dbName, collName));
            this.namespaceTopicCache.put(namespace, cachedTopic);
        }
        return cachedTopic;
    }

    private String getStringFromPath(String fieldPath, BsonDocument changeStreamDocument) {
        return BsonDocumentFieldLookup.fieldLookup(fieldPath, changeStreamDocument).map(bsonValue -> bsonValue.isString() ? bsonValue.asString().getValue() : "").orElse("");
    }

    private String getUndecoratedTopicNameFromNamespaceMap(String dbName, String collName) {
        String exactMatch = (String)this.topicNamespaceMap.get((Object)DefaultTopicMapper.namespace(dbName, collName), (Object)"");
        if (!exactMatch.isEmpty()) {
            return exactMatch;
        }
        String databaseMatch = (String)this.topicNamespaceMap.get((Object)dbName, (Object)"");
        if (!databaseMatch.isEmpty()) {
            return this.undecoratedTopicName(databaseMatch, collName);
        }
        return (String)this.topicNamespaceMap.get((Object)ALL, (Object)this.undecoratedTopicName(dbName, collName));
    }

    private static String namespace(String dbName, String collName) {
        return collName.isEmpty() ? dbName : dbName + '.' + collName;
    }

    private String undecoratedTopicName(String dbNameOrMappedTopicNamePart, String collName) {
        return collName.isEmpty() ? dbNameOrMappedTopicNamePart : dbNameOrMappedTopicNamePart + this.separator + collName;
    }

    private String decorateTopicName(String undecoratedTopicName) {
        return this.prefix + undecoratedTopicName + this.suffix;
    }
}

