/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoSecurityException;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.event.ClusterClosedEvent;
import com.mongodb.event.ClusterDescriptionChangedEvent;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.ClusterOpeningEvent;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ServerApiConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.errors.ConnectException;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionValidator.class);
    private static final Document CONNECTION_STATUS = Document.parse((String)"{connectionStatus: 1, showPrivileges: true}");
    private static final String ROLES_INFO = "{rolesInfo: '%s', showPrivileges: true, showBuiltinRoles: true}";
    private static final String AUTH_INFO = "authInfo";
    private static final String AUTH_USER_PRIVILEGES = "authenticatedUserPrivileges";
    private static final String AUTH_USER_ROLES = "authenticatedUserRoles";
    private static final String INHERITED_PRIVILEGES = "inheritedPrivileges";

    public static Optional<MongoClient> validateCanConnect(Config config, String connectionStringConfigName) {
        Optional<ConfigValue> optionalConnectionString = ConfigHelper.getConfigByName(config, connectionStringConfigName);
        if (optionalConnectionString.isPresent() && optionalConnectionString.get().errorMessages().isEmpty()) {
            ConfigValue configValue = optionalConnectionString.get();
            final AtomicBoolean connected = new AtomicBoolean();
            final CountDownLatch latch = new CountDownLatch(1);
            final ConnectionString connectionString = new ConnectionString((String)configValue.value());
            MongoClientSettings.Builder mongoClientSettingsBuilder = MongoClientSettings.builder().applyConnectionString(connectionString);
            ServerApiConfig.setServerApi(mongoClientSettingsBuilder, config);
            MongoClientSettings mongoClientSettings = mongoClientSettingsBuilder.applyToClusterSettings(b -> b.addClusterListener(new ClusterListener(){

                public void clusterOpening(ClusterOpeningEvent event) {
                }

                public void clusterClosed(ClusterClosedEvent event) {
                }

                public void clusterDescriptionChanged(ClusterDescriptionChangedEvent event) {
                    ReadPreference readPreference;
                    ReadPreference readPreference2 = readPreference = connectionString.getReadPreference() != null ? connectionString.getReadPreference() : ReadPreference.primaryPreferred();
                    if (!connected.get() && event.getNewDescription().hasReadableServer(readPreference)) {
                        connected.set(true);
                        latch.countDown();
                    }
                }
            })).build();
            long latchTimeout = mongoClientSettings.getSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS) + 500;
            MongoClient mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
            try {
                if (!latch.await(latchTimeout, TimeUnit.MILLISECONDS)) {
                    configValue.addErrorMessage("Unable to connect to the server.");
                    mongoClient.close();
                }
            }
            catch (InterruptedException e) {
                mongoClient.close();
                throw new ConnectException((Throwable)e);
            }
            if (configValue.errorMessages().isEmpty()) {
                return Optional.of(mongoClient);
            }
        }
        return Optional.empty();
    }

    public static void validateUserHasActions(MongoClient mongoClient, MongoCredential credential, List<String> actions, String databaseName, String collectionName, String configName, Config config) {
        if (credential == null) {
            return;
        }
        try {
            Document connectionStatus = mongoClient.getDatabase(credential.getSource()).runCommand((Bson)CONNECTION_STATUS);
            Document authInfo = (Document)connectionStatus.get((Object)AUTH_INFO, (Object)new Document());
            List authenticatedUserPrivileges = authInfo.getList((Object)AUTH_USER_PRIVILEGES, Document.class, Collections.emptyList());
            List<String> unsupportedActions = ConnectionValidator.removeUserActions(authenticatedUserPrivileges, credential.getSource(), databaseName, collectionName, actions);
            unsupportedActions = ConnectionValidator.removeRoleActions(mongoClient, credential, databaseName, collectionName, authInfo, unsupportedActions);
            if (unsupportedActions.isEmpty()) {
                return;
            }
            String missingPermissions = String.join((CharSequence)", ", unsupportedActions);
            ConfigHelper.getConfigByName(config, configName).ifPresent(c -> c.addErrorMessage(String.format("Invalid user permissions. Missing the following action permissions: %s", missingPermissions)));
        }
        catch (MongoSecurityException e) {
            ConfigHelper.getConfigByName(config, configName).ifPresent(c -> c.addErrorMessage("Invalid user permissions authentication failed. " + e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.warn("Permission validation failed due to: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static List<String> removeUserActions(List<Document> privileges, String authSource, String databaseName, String collectionName, List<String> userActions) {
        if (privileges.isEmpty() || userActions.isEmpty()) {
            return userActions;
        }
        ArrayList<String> unsupportedUserActions = new ArrayList<String>(userActions);
        for (Document privilege : privileges) {
            Document resource = (Document)privilege.get((Object)"resource", (Object)new Document());
            if (resource.containsKey((Object)"cluster") && resource.getBoolean((Object)"cluster").booleanValue()) {
                unsupportedUserActions.removeAll(privilege.getList((Object)"actions", String.class, Collections.emptyList()));
            } else if (resource.containsKey((Object)"db") && resource.containsKey((Object)"collection")) {
                boolean collectionMatches;
                String database = resource.getString((Object)"db");
                String collection = resource.getString((Object)"collection");
                boolean resourceMatches = false;
                boolean bl = collectionMatches = collection.isEmpty() || collection.equals(collectionName);
                if (database.isEmpty() && collectionMatches) {
                    resourceMatches = true;
                } else if (database.equals(authSource) && collection.isEmpty()) {
                    resourceMatches = true;
                } else if (database.equals(databaseName) && collectionMatches) {
                    resourceMatches = true;
                }
                if (resourceMatches) {
                    unsupportedUserActions.removeAll(privilege.getList((Object)"actions", String.class, Collections.emptyList()));
                }
            }
            if (!unsupportedUserActions.isEmpty()) continue;
            break;
        }
        return unsupportedUserActions;
    }

    private static List<String> removeRoleActions(MongoClient mongoClient, MongoCredential credential, String databaseName, String collectionName, Document authInfo, List<String> actions) {
        if (actions.isEmpty()) {
            return actions;
        }
        List<String> unsupportedActions = new ArrayList<String>(actions);
        for (Document userRole : authInfo.getList((Object)AUTH_USER_ROLES, Document.class, Collections.emptyList())) {
            Document rolesInfo = mongoClient.getDatabase(userRole.getString((Object)"db")).runCommand((Bson)Document.parse((String)String.format(ROLES_INFO, userRole.getString((Object)"role"))));
            for (Document roleInfo : rolesInfo.getList((Object)"roles", Document.class, Collections.emptyList())) {
                unsupportedActions = ConnectionValidator.removeUserActions(roleInfo.getList((Object)INHERITED_PRIVILEGES, Document.class, Collections.emptyList()), credential.getSource(), databaseName, collectionName, unsupportedActions);
                if (!unsupportedActions.isEmpty()) continue;
                return unsupportedActions;
            }
            if (!unsupportedActions.isEmpty()) continue;
            return unsupportedActions;
        }
        return unsupportedActions;
    }

    private ConnectionValidator() {
    }
}

