/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop;

import com.mongodb.hadoop.input.BSONFileRecordReader;
import com.mongodb.hadoop.splitter.BSONSplitter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;

public class BSONFileInputFormat
extends FileInputFormat {
    private static final Log LOG = LogFactory.getLog(BSONFileInputFormat.class);

    public RecordReader createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        BSONFileRecordReader reader = new BSONFileRecordReader();
        reader.initialize(split, context);
        return reader;
    }

    public static PathFilter getInputPathFilter(JobContext context) {
        Configuration conf = context.getConfiguration();
        Class filterClass = conf.getClass("bson.pathfilter.class", null, PathFilter.class);
        return filterClass != null ? (PathFilter)ReflectionUtils.newInstance((Class)filterClass, (Configuration)conf) : null;
    }

    public List<FileSplit> getSplits(JobContext context) throws IOException {
        Configuration config = context.getConfiguration();
        PathFilter pf = BSONFileInputFormat.getInputPathFilter(context);
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        List inputFiles = this.listStatus(context);
        for (FileStatus file : inputFiles) {
            if (pf != null && !pf.accept(file.getPath())) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)String.format("skipping file %s not matched path filter.", file.getPath()));
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("processing file " + file.getPath()));
            }
            BSONSplitter splitter = new BSONSplitter();
            splitter.setConf(config);
            splitter.setInputPath(file.getPath());
            Path splitFilePath = new Path(file.getPath().getParent(), "." + file.getPath().getName() + ".splits");
            try {
                splitter.loadSplitsFromSplitFile(file, splitFilePath);
            }
            catch (BSONSplitter.NoSplitFileException nsfe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("No split file for %s; building split file", file.getPath()));
                }
                splitter.readSplitsForFile(file);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("BSONSplitter found %d splits.", splitter.getAllSplits().size()));
            }
            splits.addAll(splitter.getAllSplits());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Total of %d found.", splits.size()));
        }
        return splits;
    }
}

