/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.input;

import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.LazyBSONCallback;
import org.bson.LazyBSONDecoder;

public class BSONFileRecordReader
extends RecordReader<NullWritable, BSONObject> {
    private static final Log LOG = LogFactory.getLog(BSONFileRecordReader.class);
    private FileSplit fileSplit;
    private BSONObject value;
    private FSDataInputStream in;
    private int numDocsRead = 0;
    private boolean finished = false;
    private BSONCallback callback;
    private BSONDecoder decoder;

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.fileSplit = (FileSplit)inputSplit;
        Configuration configuration = context.getConfiguration();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reading split " + this.fileSplit));
        }
        Path file = this.fileSplit.getPath();
        FileSystem fs = file.getFileSystem(configuration);
        this.in = fs.open(file, 0x1000000);
        this.in.seek(this.fileSplit.getStart());
        if (MongoConfigUtil.getLazyBSON(configuration)) {
            this.callback = new LazyBSONCallback();
            this.decoder = new LazyBSONDecoder();
        } else {
            this.callback = new BasicBSONCallback();
            this.decoder = new BasicBSONDecoder();
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        try {
            if (this.in.getPos() >= this.fileSplit.getStart() + this.fileSplit.getLength()) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                return false;
            }
            this.callback.reset();
            this.decoder.decode((InputStream)this.in, this.callback);
            this.value = (BSONObject)this.callback.get();
            ++this.numDocsRead;
            if (this.numDocsRead % 10000 == 0 && LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("read %d docs from %s at %d", this.numDocsRead, this.fileSplit, this.in.getPos()));
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error reading key/value from bson file on line %d: %s", this.numDocsRead, e.getMessage()));
            try {
                this.close();
            }
            catch (Exception e2) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public BSONObject getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.finished) {
            return 1.0f;
        }
        if (this.in != null) {
            return (float)(this.in.getPos() - this.fileSplit.getStart()) / (float)this.fileSplit.getLength();
        }
        return 0.0f;
    }

    public void close() throws IOException {
        this.finished = true;
        if (this.in != null) {
            this.in.close();
        }
    }
}

