/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.input;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoURI;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.io.Bits;

public class MongoInputSplit
extends InputSplit
implements Writable,
org.apache.hadoop.mapred.InputSplit {
    private static final Log LOG = LogFactory.getLog(MongoInputSplit.class);
    protected MongoClientURI inputURI;
    protected MongoClientURI authURI;
    protected String keyField = "_id";
    protected DBObject fields;
    protected DBObject query;
    protected DBObject sort;
    protected DBObject min;
    protected DBObject max;
    protected boolean notimeout = false;
    protected transient DBCursor cursor;
    protected static transient BSONEncoder _bsonEncoder = new BasicBSONEncoder();
    protected static transient BSONDecoder _bsonDecoder = new BasicBSONDecoder();

    public void setInputURI(MongoClientURI inputURI) {
        this.inputURI = inputURI;
    }

    public MongoClientURI getInputURI() {
        return this.inputURI;
    }

    @Deprecated
    public void setAuthURI(MongoURI authURI) {
        this.setAuthURI(authURI != null ? new MongoClientURI(authURI.toString()) : null);
    }

    public void setAuthURI(MongoClientURI authURI) {
        this.authURI = authURI;
    }

    public MongoClientURI getAuthURI() {
        return this.authURI;
    }

    public String[] getLocations() {
        if (this.inputURI == null) {
            return null;
        }
        return this.inputURI.getHosts().toArray(new String[this.inputURI.getHosts().size()]);
    }

    public long getLength() {
        return Long.MAX_VALUE;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public DBObject getFields() {
        return this.fields;
    }

    public void setFields(DBObject fields) {
        this.fields = fields;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public void setQuery(DBObject query) {
        this.query = query;
    }

    public DBObject getSort() {
        return this.sort;
    }

    public void setSort(DBObject sort) {
        this.sort = sort;
    }

    public DBObject getMin() {
        return this.min;
    }

    public void setMin(DBObject min) {
        this.min = min;
    }

    public DBObject getMax() {
        return this.max;
    }

    public void setMax(DBObject max) {
        this.max = max;
    }

    public boolean getNoTimeout() {
        return this.notimeout;
    }

    public void setNoTimeout(boolean notimeout) {
        this.notimeout = notimeout;
    }

    public void write(DataOutput out) throws IOException {
        DBObject spec = BasicDBObjectBuilder.start().add("inputURI", this.getInputURI().toString()).add("authURI", this.getAuthURI() != null ? this.getAuthURI().toString() : null).add("keyField", this.getKeyField()).add("fields", this.getFields()).add("query", this.getQuery()).add("sort", this.getSort()).add("min", this.getMin()).add("max", this.getMax()).add("notimeout", this.getNoTimeout()).get();
        byte[] buf = _bsonEncoder.encode(spec);
        out.write(buf);
    }

    public void readFields(DataInput in) throws IOException {
        BasicBSONCallback cb = new BasicBSONCallback();
        byte[] l = new byte[4];
        in.readFully(l);
        int dataLen = Bits.readInt(l);
        byte[] data = new byte[dataLen + 4];
        System.arraycopy(l, 0, data, 0, 4);
        in.readFully(data, 4, dataLen - 4);
        _bsonDecoder.decode(data, (BSONCallback)cb);
        BSONObject spec = (BSONObject)cb.get();
        this.setInputURI(new MongoClientURI((String)spec.get("inputURI")));
        if (spec.get("authURI") != null) {
            this.setAuthURI(new MongoClientURI((String)spec.get("authURI")));
        } else {
            this.setAuthURI((MongoClientURI)null);
        }
        this.setKeyField((String)spec.get("keyField"));
        BSONObject temp = (BSONObject)spec.get("fields");
        this.setFields(temp != null ? new BasicDBObject(temp.toMap()) : null);
        temp = (BSONObject)spec.get("query");
        this.setQuery(temp != null ? new BasicDBObject(temp.toMap()) : null);
        temp = (BSONObject)spec.get("sort");
        this.setSort(temp != null ? new BasicDBObject(temp.toMap()) : null);
        temp = (BSONObject)spec.get("min");
        this.setMin(temp != null ? new BasicDBObject(temp.toMap()) : null);
        temp = (BSONObject)spec.get("max");
        this.setMax(temp != null ? new BasicDBObject(temp.toMap()) : null);
        this.setNoTimeout((Boolean)spec.get("notimeout"));
    }

    public DBCursor getCursor() {
        if (this.cursor == null) {
            DBCollection coll = this.authURI != null ? MongoConfigUtil.getCollectionWithAuth(this.inputURI, this.authURI) : MongoConfigUtil.getCollection(this.inputURI);
            this.cursor = coll.find(this.query, this.fields).sort(this.sort);
            if (this.notimeout) {
                this.cursor.setOptions(16);
            }
            if (this.min != null) {
                this.cursor.addSpecial("$min", this.min);
            }
            if (this.max != null) {
                this.cursor.addSpecial("$max", this.max);
            }
        }
        return this.cursor;
    }

    public String toString() {
        return "MongoInputSplit{URI=" + this.inputURI.toString() + ", authURI=" + this.authURI + ", min=" + this.min + ", max=" + this.max + ", query=" + this.query + ", sort=" + this.sort + ", fields=" + this.fields + ", notimeout=" + this.notimeout + '}';
    }

    public int hashCode() {
        int result = this.inputURI != null ? this.inputURI.hashCode() : 0;
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
        result = 31 * result + (this.notimeout ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MongoInputSplit that = (MongoInputSplit)((Object)o);
        if (this.getNoTimeout() != that.getNoTimeout()) {
            return false;
        }
        if (this.getFields() != null ? !this.getFields().equals(that.getFields()) : that.getFields() != null) {
            return false;
        }
        if (this.getInputURI() != null ? !this.getInputURI().equals(that.getInputURI()) : that.getInputURI() != null) {
            return false;
        }
        if (this.getQuery() != null ? !this.getQuery().equals(that.getQuery()) : that.getQuery() != null) {
            return false;
        }
        if (this.getSort() != null ? !this.getSort().equals(that.getSort()) : that.getSort() != null) {
            return false;
        }
        if (this.getMax() != null ? !this.getMax().equals(that.getMax()) : that.getMax() != null) {
            return false;
        }
        return !(this.getMin() != null ? !this.getMin().equals(that.getMin()) : that.getMin() != null);
    }
}

