/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred;

import com.mongodb.hadoop.io.BSONWritable;
import com.mongodb.hadoop.mapred.input.BSONFileRecordReader;
import com.mongodb.hadoop.splitter.BSONSplitter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class BSONFileInputFormat
extends FileInputFormat {
    protected boolean isSplitable(JobContext context, Path filename) {
        return true;
    }

    public org.apache.hadoop.mapred.FileSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        FileStatus[] inputFiles = this.listStatus(job);
        ArrayList<org.apache.hadoop.mapred.FileSplit> results = new ArrayList<org.apache.hadoop.mapred.FileSplit>();
        for (FileStatus file : inputFiles) {
            BSONSplitter splitter = new BSONSplitter();
            splitter.setConf((Configuration)job);
            splitter.setInputPath(file.getPath());
            Path splitFilePath = new Path(file.getPath().getParent(), "." + file.getPath().getName() + ".splits");
            try {
                splitter.loadSplitsFromSplitFile(file, splitFilePath);
            }
            catch (BSONSplitter.NoSplitFileException nsfe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("No split file for %s; building split file", file.getPath()));
                }
                splitter.readSplitsForFile(file);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("BSONSplitter found %d splits.", splitter.getAllSplits().size()));
            }
            for (FileSplit split : splitter.getAllSplits()) {
                org.apache.hadoop.mapred.FileSplit fsplit = new org.apache.hadoop.mapred.FileSplit(split.getPath(), split.getStart(), split.getLength(), split.getLocations());
                results.add(fsplit);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Total of %d found.", results.size()));
        }
        return results.toArray(new org.apache.hadoop.mapred.FileSplit[results.size()]);
    }

    public RecordReader<NullWritable, BSONWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        BSONFileRecordReader reader = new BSONFileRecordReader();
        reader.initialize(split, (Configuration)job);
        return reader;
    }
}

