/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.output;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.hadoop.io.BSONWritable;
import com.mongodb.hadoop.io.MongoUpdateWritable;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONEncoder;

public class BSONFileRecordWriter<K, V>
extends RecordWriter<K, V> {
    private BSONEncoder bsonEnc = new BasicBSONEncoder();
    private FSDataOutputStream outFile = null;
    private FSDataOutputStream splitsFile = null;
    private long bytesWritten = 0L;
    private long currentSplitLen = 0L;
    private long currentSplitStart = 0L;
    private long splitSize;

    public BSONFileRecordWriter(FSDataOutputStream outFile, FSDataOutputStream splitsFile, long splitSize) {
        this.outFile = outFile;
        this.splitsFile = splitsFile;
        this.splitSize = splitSize;
    }

    public BSONFileRecordWriter(FSDataOutputStream outFile) {
        this(outFile, null, 0L);
    }

    public void close(TaskAttemptContext context) throws IOException {
        if (this.outFile != null) {
            this.outFile.close();
        }
        this.writeSplitData(0, true);
        if (this.splitsFile != null) {
            this.splitsFile.close();
        }
    }

    public void write(K key, V value) throws IOException {
        FSDataOutputStream destination = this.outFile;
        if (value instanceof MongoUpdateWritable) {
            throw new IllegalArgumentException("MongoUpdateWriteable can only be used to output to a mongo collection, not a static BSON file.");
        }
        Object keyBSON = null;
        BSONObject toEncode = null;
        if (key != null && (keyBSON = BSONWritable.toBSON(key)) != null) {
            toEncode = new BasicDBObject();
        }
        if (value instanceof BSONWritable) {
            if (toEncode != null) {
                toEncode.putAll(((BSONWritable)value).getDoc());
            } else {
                toEncode = ((BSONWritable)value).getDoc();
            }
        } else if (value instanceof BSONObject) {
            if (toEncode != null) {
                toEncode.putAll((BSONObject)value);
            } else {
                toEncode = (BSONObject)value;
            }
        } else if (toEncode != null) {
            toEncode.put("value", BSONWritable.toBSON(value));
        } else {
            BasicDBObject o = new BasicDBObject();
            o.put("value", BSONWritable.toBSON(value));
            toEncode = o;
        }
        if (keyBSON != null) {
            toEncode.put("_id", keyBSON);
        }
        byte[] outputByteBuf = this.bsonEnc.encode(toEncode);
        destination.write(outputByteBuf, 0, outputByteBuf.length);
        this.bytesWritten += (long)outputByteBuf.length;
        this.writeSplitData(outputByteBuf.length, false);
    }

    private void writeSplitData(int docSize, boolean force) throws IOException {
        if (this.splitsFile == null) {
            return;
        }
        if (force || this.currentSplitLen + (long)docSize >= this.splitSize) {
            DBObject splitObj = BasicDBObjectBuilder.start().add("s", this.currentSplitStart).add("l", this.currentSplitLen).get();
            byte[] encodedObj = this.bsonEnc.encode(splitObj);
            this.splitsFile.write(encodedObj, 0, encodedObj.length);
            this.currentSplitLen = 0L;
            this.currentSplitStart = this.bytesWritten - (long)docSize;
        } else {
            this.currentSplitLen += (long)docSize;
        }
    }
}

