/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.pig;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.hadoop.BSONFileInputFormat;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.LoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.Utils;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;
import org.bson.types.ObjectId;

public class BSONLoader
extends LoadFunc {
    private static TupleFactory tupleFactory = TupleFactory.getInstance();
    private static BagFactory bagFactory = BagFactory.getInstance();
    private static final Log LOG = LogFactory.getLog(BSONLoader.class);
    private final BSONFileInputFormat inputFormat = new BSONFileInputFormat();
    protected RecordReader in = null;
    private ResourceSchema.ResourceFieldSchema[] fields;
    protected ResourceSchema schema = null;
    private String idAlias = null;

    public BSONLoader() {
    }

    public BSONLoader(String idAlias, String userSchema) {
        this.idAlias = idAlias;
        try {
            this.schema = new ResourceSchema(Utils.getSchemaFromString((String)userSchema));
            this.fields = this.schema.getFields();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Schema Format");
        }
    }

    public void setLocation(String location, Job job) throws IOException {
        BSONFileInputFormat.setInputPaths((Job)job, (String)location);
    }

    public InputFormat getInputFormat() {
        return this.inputFormat;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.in = reader;
    }

    public Tuple getNext() throws IOException {
        try {
            Tuple t;
            if (!this.in.nextKeyValue()) {
                return null;
            }
            BSONObject val = (BSONObject)this.in.getCurrentValue();
            if (this.fields == null) {
                t = tupleFactory.newTuple(1);
                t.set(0, BSONLoader.convertBSONtoPigType(val));
            } else {
                t = tupleFactory.newTuple(this.fields.length);
                for (int i = 0; i < this.fields.length; ++i) {
                    String fieldTemp = this.fields[i].getName();
                    if (this.idAlias != null && this.idAlias.equals(fieldTemp)) {
                        fieldTemp = "_id";
                    }
                    t.set(i, BSONLoader.readField(val.get(fieldTemp), this.fields[i]));
                }
            }
            return t;
        }
        catch (InterruptedException e) {
            throw new ExecException("Error while reading input", 6018);
        }
    }

    protected static Object readField(Object obj, ResourceSchema.ResourceFieldSchema field) throws IOException {
        if (obj == null) {
            return null;
        }
        try {
            if (field == null) {
                return obj;
            }
            switch (field.getType()) {
                case 10: {
                    return Integer.parseInt(obj.toString());
                }
                case 15: {
                    return Long.parseLong(obj.toString());
                }
                case 20: {
                    return Float.valueOf(Float.parseFloat(obj.toString()));
                }
                case 25: {
                    return Double.parseDouble(obj.toString());
                }
                case 50: {
                    return BSONLoader.convertBSONtoPigType(obj);
                }
                case 55: {
                    return obj.toString();
                }
                case 110: {
                    ResourceSchema s = field.getSchema();
                    ResourceSchema.ResourceFieldSchema[] fs = s.getFields();
                    Tuple t = tupleFactory.newTuple(fs.length);
                    BasicDBObject val = (BasicDBObject)obj;
                    for (int j = 0; j < fs.length; ++j) {
                        t.set(j, BSONLoader.readField(val.get(fs[j].getName()), fs[j]));
                    }
                    return t;
                }
                case 120: {
                    ResourceSchema s = field.getSchema();
                    ResourceSchema.ResourceFieldSchema[] fs = s.getFields();
                    s = fs[0].getSchema();
                    fs = s.getFields();
                    DataBag bag = bagFactory.newDefaultBag();
                    BasicDBList vals = (BasicDBList)obj;
                    for (Object val1 : vals) {
                        Tuple t = tupleFactory.newTuple(fs.length);
                        for (int k = 0; k < fs.length; ++k) {
                            t.set(k, BSONLoader.readField(((BasicDBObject)val1).get(fs[k].getName()), fs[k]));
                        }
                        bag.add(t);
                    }
                    return bag;
                }
                case 100: {
                    ResourceSchema s = field.getSchema();
                    ResourceSchema.ResourceFieldSchema[] fs = s != null ? s.getFields() : null;
                    BasicBSONObject inputMap = (BasicBSONObject)obj;
                    HashMap<String, Object> outputMap = new HashMap<String, Object>();
                    for (String key : inputMap.keySet()) {
                        if (fs != null) {
                            outputMap.put(key, BSONLoader.readField(inputMap.get(key), fs[0]));
                            continue;
                        }
                        outputMap.put(key, BSONLoader.readField(inputMap.get(key), null));
                    }
                    return outputMap;
                }
            }
            LOG.info((Object)("asfkjabskfjbsaf default for " + field.getName()));
            return BSONLoader.convertBSONtoPigType(obj);
        }
        catch (Exception e) {
            String fieldName = field.getName() == null ? "" : field.getName();
            String type = (String)DataType.genTypeToNameMap().get(field.getType());
            LOG.warn((Object)("Type " + type + " for field " + fieldName + " can not be applied to " + obj.getClass().toString()));
            return null;
        }
    }

    public static Object convertBSONtoPigType(Object o) throws ExecException {
        if (o == null) {
            return null;
        }
        if (o instanceof Number || o instanceof String) {
            return o;
        }
        if (o instanceof Date) {
            return ((Date)o).getTime();
        }
        if (o instanceof ObjectId) {
            return o.toString();
        }
        if (o instanceof BasicBSONList) {
            BasicBSONList bl = (BasicBSONList)o;
            Tuple t = tupleFactory.newTuple(bl.size());
            for (int i = 0; i < bl.size(); ++i) {
                t.set(i, BSONLoader.convertBSONtoPigType(bl.get(i)));
            }
            return t;
        }
        if (o instanceof Map) {
            Map fieldsMap = (Map)o;
            HashMap pigMap = new HashMap(fieldsMap.size());
            for (Map.Entry field : fieldsMap.entrySet()) {
                pigMap.put(field.getKey(), BSONLoader.convertBSONtoPigType(field.getValue()));
            }
            return pigMap;
        }
        return o;
    }
}

