/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.pig;

import com.mongodb.hadoop.MongoInputFormat;
import com.mongodb.hadoop.pig.BSONLoader;
import com.mongodb.hadoop.pig.MongoStorage;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.Utils;
import org.bson.BSONObject;

public class MongoLoader
extends LoadFunc
implements LoadMetadata {
    private static final Log LOG = LogFactory.getLog(MongoStorage.class);
    private static TupleFactory tupleFactory = TupleFactory.getInstance();
    private ResourceSchema schema = null;
    private RecordReader in = null;
    private final MongoInputFormat inputFormat = new MongoInputFormat();
    private ResourceSchema.ResourceFieldSchema[] fields;
    private String idAlias = null;

    public void setUDFContextSignature(String signature) {
    }

    public MongoLoader() {
        LOG.info((Object)"Initializing MongoLoader in dynamic schema mode.");
        this.schema = null;
        this.fields = null;
    }

    public ResourceSchema.ResourceFieldSchema[] getFields() {
        return this.fields;
    }

    public MongoLoader(String userSchema, String idAlias) {
        this.idAlias = idAlias;
        try {
            this.schema = new ResourceSchema(Utils.getSchemaFromString((String)userSchema));
            this.fields = this.schema.getFields();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Schema Format");
        }
    }

    public MongoLoader(String userSchema) {
        this(userSchema, null);
    }

    public void setLocation(String location, Job job) throws IOException {
        MongoConfigUtil.setInputURI(job.getConfiguration(), location);
    }

    public InputFormat getInputFormat() throws IOException {
        return this.inputFormat;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.in = reader;
        if (this.in == null) {
            throw new IOException("Invalid Record Reader");
        }
    }

    public Tuple getNext() throws IOException {
        Tuple t;
        BSONObject val;
        try {
            if (!this.in.nextKeyValue()) {
                return null;
            }
            val = (BSONObject)this.in.getCurrentValue();
        }
        catch (Exception ie) {
            throw new IOException(ie);
        }
        if (this.fields == null) {
            t = tupleFactory.newTuple(1);
            t.set(0, BSONLoader.convertBSONtoPigType(val));
        } else {
            t = tupleFactory.newTuple(this.fields.length);
            for (int i = 0; i < this.fields.length; ++i) {
                String fieldTemp = this.fields[i].getName();
                if (this.idAlias != null && this.idAlias.equals(fieldTemp)) {
                    fieldTemp = "_id";
                }
                t.set(i, BSONLoader.readField(val.get(fieldTemp), this.fields[i]));
            }
        }
        return t;
    }

    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return location;
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        if (this.schema != null) {
            return this.schema;
        }
        return null;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }
}

