/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.pig;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.hadoop.MongoOutputFormat;
import com.mongodb.hadoop.output.MongoRecordWriter;
import com.mongodb.hadoop.pig.MongoStorageOptions;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreMetadata;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;

public class MongoStorage
extends StoreFunc
implements StoreMetadata {
    private static final Log LOG = LogFactory.getLog(MongoStorage.class);
    static final String PIG_OUTPUT_SCHEMA = "mongo.pig.output.schema";
    static final String PIG_OUTPUT_SCHEMA_UDF_CONTEXT = "mongo.pig.output.schema.udf_context";
    protected ResourceSchema schema = null;
    private final MongoStorageOptions options;
    private String udfContextSignature = null;
    private MongoRecordWriter recordWriter = null;

    public MongoStorage() {
        this.options = null;
    }

    public MongoStorage(String ... args) throws ParseException {
        this.options = MongoStorageOptions.parseArguments(args);
    }

    public void checkSchema(ResourceSchema schema) throws IOException {
        LOG.info((Object)("checking schema " + schema.toString()));
        this.schema = schema;
        Properties properties = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfContextSignature});
        properties.setProperty(PIG_OUTPUT_SCHEMA_UDF_CONTEXT, schema.toString());
    }

    public void storeSchema(ResourceSchema schema, String location, Job job) {
    }

    public void storeStatistics(ResourceStatistics stats, String location, Job job) {
    }

    public void putNext(Tuple tuple) throws IOException {
        LOG.info((Object)("writing " + tuple.toString()));
        BasicDBObjectBuilder builder = BasicDBObjectBuilder.start();
        ResourceSchema.ResourceFieldSchema[] fields = this.schema.getFields();
        for (int i = 0; i < fields.length; ++i) {
            this.writeField(builder, fields[i], tuple.get(i));
        }
        LOG.info((Object)("writing out:" + builder.get().toString()));
        this.recordWriter.write(null, builder.get());
    }

    protected void writeField(BasicDBObjectBuilder builder, ResourceSchema.ResourceFieldSchema field, Object d) throws IOException {
        if (d == null) {
            builder.add(field.getName(), null);
            return;
        }
        ResourceSchema s = field.getSchema();
        byte i = field.getType();
        if (i == 10) {
            builder.add(field.getName(), d);
        } else if (i == 15) {
            builder.add(field.getName(), d);
        } else if (i == 20) {
            builder.add(field.getName(), d);
        } else if (i == 25) {
            builder.add(field.getName(), d);
        } else if (i == 50) {
            builder.add(field.getName(), d.toString());
        } else if (i == 55) {
            builder.add(field.getName(), d);
        } else if (i == 110) {
            if (s == null) {
                throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + field.getName());
            }
            ResourceSchema.ResourceFieldSchema[] fs = s.getFields();
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            for (int j = 0; j < fs.length; ++j) {
                m.put(fs[j].getName(), ((Tuple)d).get(j));
            }
            builder.add(field.getName(), m);
        } else if (i == 120) {
            if (s == null) {
                throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + field.getName());
            }
            ResourceSchema.ResourceFieldSchema[] fs = s.getFields();
            if (fs.length != 1 || fs[0].getType() != 110) {
                throw new IOException("Found a bag without a tuple inside!");
            }
            s = fs[0].getSchema();
            if (s == null) {
                throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + field.getName());
            }
            fs = s.getFields();
            ArrayList a = new ArrayList();
            for (Tuple t : (DataBag)d) {
                LinkedHashMap<String, Object> ma = new LinkedHashMap<String, Object>();
                for (int j = 0; j < fs.length; ++j) {
                    ma.put(fs[j].getName(), t.get(j));
                }
                a.add(ma);
            }
            builder.add(field.getName(), a);
        } else if (i == 100) {
            Map map = (Map)d;
            for (Object key : map.keySet()) {
                builder.add(key.toString(), map.get(key));
            }
        }
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.recordWriter = (MongoRecordWriter)writer;
        LOG.info((Object)("Preparing to write to " + (Object)((Object)this.recordWriter)));
        if (this.recordWriter == null) {
            throw new IOException("Invalid Record Writer");
        }
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfContextSignature});
        String strSchema = p.getProperty(PIG_OUTPUT_SCHEMA_UDF_CONTEXT);
        if (strSchema == null) {
            throw new IOException("Could not find schema in UDF context");
        }
        try {
            this.schema = new ResourceSchema(Utils.getSchemaFromString((String)strSchema));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.options != null) {
            for (MongoStorageOptions.Index in : this.options.getIndexes()) {
                this.recordWriter.ensureIndex(in.index, in.options);
            }
        }
    }

    public OutputFormat getOutputFormat() throws IOException {
        return this.options == null ? new MongoOutputFormat() : new MongoOutputFormat(this.options.getUpdate().keys, this.options.getUpdate().multi);
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        Configuration config = job.getConfiguration();
        LOG.info((Object)("Store Location Config: " + config + " For URI: " + location));
        MongoConfigUtil.setOutputURI(config, location);
        Properties properties = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfContextSignature});
        config.set(PIG_OUTPUT_SCHEMA, properties.getProperty(PIG_OUTPUT_SCHEMA_UDF_CONTEXT));
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.udfContextSignature = signature;
    }
}

