/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.MongoClientURI;
import com.mongodb.hadoop.splitter.MongoCollectionSplitter;
import com.mongodb.hadoop.splitter.MongoSplitter;
import com.mongodb.hadoop.splitter.ShardChunkMongoSplitter;
import com.mongodb.hadoop.splitter.ShardMongoSplitter;
import com.mongodb.hadoop.splitter.SingleMongoSplitter;
import com.mongodb.hadoop.splitter.StandaloneMongoSplitter;
import com.mongodb.hadoop.util.MongoConfigUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;

public final class MongoSplitterFactory {
    private static final Log LOG = LogFactory.getLog(MongoSplitterFactory.class);

    private MongoSplitterFactory() {
    }

    public static MongoSplitter getSplitterByClass(Configuration conf, String className) {
        Class<MongoSplitter> splitterClass = MongoConfigUtil.getClassByName(conf, className, MongoSplitter.class);
        if (splitterClass != null) {
            MongoSplitter splitter = (MongoSplitter)ReflectionUtils.newInstance(splitterClass, (Configuration)conf);
            splitter.setConfiguration(conf);
            return splitter;
        }
        return null;
    }

    public static MongoCollectionSplitter getSplitterByStats(MongoClientURI uri, Configuration config) {
        MongoCollectionSplitter returnVal;
        if (!MongoConfigUtil.createInputSplits(config)) {
            returnVal = new SingleMongoSplitter(config);
        } else {
            CommandResult stats;
            MongoClientURI authURI = MongoConfigUtil.getAuthURI(config);
            if (authURI != null) {
                DBCollection coll = MongoConfigUtil.getCollectionWithAuth(uri, authURI);
                stats = coll.getStats();
                LOG.info((Object)("Retrieved Collection stats:" + stats));
            } else {
                DBCollection coll = MongoConfigUtil.getCollection(uri);
                stats = coll.getStats();
            }
            if (!stats.getBoolean("ok", false)) {
                throw new RuntimeException("Unable to calculate input splits from collection stats: " + stats.getString("errmsg"));
            }
            returnVal = !stats.getBoolean("sharded", false) ? new StandaloneMongoSplitter(config) : (MongoConfigUtil.isShardChunkedSplittingEnabled(config) ? new ShardChunkMongoSplitter(config) : (MongoConfigUtil.canReadSplitsFromShards(config) ? new ShardMongoSplitter(config) : new StandaloneMongoSplitter(config)));
        }
        return returnVal;
    }

    public static MongoSplitter getSplitter(Configuration config) {
        String splitterClassName = config.get("mongo.splitter.class");
        MongoSplitter customSplitter = MongoSplitterFactory.getSplitterByClass(config, splitterClassName);
        if (customSplitter != null) {
            return customSplitter;
        }
        return MongoSplitterFactory.getSplitterByStats(MongoConfigUtil.getInputURI(config), config);
    }
}

