/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.MongoClientURI;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.splitter.MongoCollectionSplitter;
import com.mongodb.hadoop.splitter.SplitFailedException;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;

public class ShardMongoSplitter
extends MongoCollectionSplitter {
    public ShardMongoSplitter(Configuration conf) {
        super(conf);
    }

    @Override
    public List<InputSplit> calculateSplits() throws SplitFailedException {
        this.init();
        ArrayList<InputSplit> returnVal = new ArrayList<InputSplit>();
        MongoClientURI inputURI = MongoConfigUtil.getInputURI(this.conf);
        Map<String, String> shardsMap = this.getShardsMap();
        for (Map.Entry<String, String> entry : shardsMap.entrySet()) {
            String shardHosts = entry.getValue();
            MongoInputSplit chunkSplit = this.createSplitFromBounds(null, null);
            chunkSplit.setInputURI(ShardMongoSplitter.rewriteURI(inputURI, shardHosts));
            returnVal.add(chunkSplit);
        }
        return returnVal;
    }
}

