/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.CommandResult;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.splitter.MongoCollectionSplitter;
import com.mongodb.hadoop.splitter.SplitFailedException;
import com.mongodb.hadoop.util.MongoClientURIBuilder;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;

public class StandaloneMongoSplitter
extends MongoCollectionSplitter {
    private static final Log LOG = LogFactory.getLog(StandaloneMongoSplitter.class);

    public StandaloneMongoSplitter(Configuration conf) {
        super(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputSplit> calculateSplits() throws SplitFailedException {
        BasicDBList splitData;
        CommandResult data;
        this.init();
        DBObject splitKey = MongoConfigUtil.getInputSplitKey(this.conf);
        int splitSize = MongoConfigUtil.getSplitSize(this.conf);
        ArrayList<InputSplit> returnVal = new ArrayList<InputSplit>();
        String ns = this.inputCollection.getFullName();
        MongoClientURI inputURI = MongoConfigUtil.getInputURI(this.conf);
        LOG.info((Object)("Running splitvector to check splits against " + inputURI));
        DBObject cmd = BasicDBObjectBuilder.start("splitVector", ns).add("keyPattern", splitKey).add("force", false).add("maxChunkSize", splitSize).get();
        boolean ok = true;
        if (this.authDB == null) {
            try {
                data = this.inputCollection.getDB().getSisterDB("admin").command(cmd);
            }
            catch (MongoException e) {
                data = null;
                LOG.info((Object)e.getMessage(), (Throwable)e);
                if (e.getMessage().contains("unrecognized command: splitVector")) {
                    ok = false;
                }
                throw e;
            }
        } else {
            data = this.authDB.command(cmd);
        }
        if (data != null) {
            if (data.containsField("$err")) {
                throw new SplitFailedException("Error calculating splits: " + data);
            }
            if (!data.get("ok").equals(1.0)) {
                ok = false;
            }
        }
        if (!ok) {
            block22: {
                CommandResult stats = this.inputCollection.getStats();
                if (stats.containsField("primary")) {
                    DBCursor shards = this.inputCollection.getDB().getSisterDB("config").getCollection("shards").find(new BasicDBObject("_id", stats.getString("primary")));
                    try {
                        if (!shards.hasNext()) break block22;
                        DBObject shard = shards.next();
                        MongoClientURI shardHost = new MongoClientURIBuilder(inputURI).host((String)shard.get("host")).build();
                        MongoClient shardClient = null;
                        try {
                            shardClient = new MongoClient(shardHost);
                            data = shardClient.getDB("admin").command(cmd);
                        }
                        catch (UnknownHostException e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (shardClient != null) {
                                shardClient.close();
                            }
                        }
                    }
                    finally {
                        shards.close();
                    }
                }
            }
            if (!data.get("ok").equals(1.0)) {
                throw new SplitFailedException("Unable to calculate input splits: " + data.get("errmsg"));
            }
        }
        if ((splitData = (BasicDBList)data.get("splitKeys")).size() == 0) {
            LOG.warn((Object)"WARNING: No Input Splits were calculated by the split code. Proceeding with a *single* split. Data may be too small, try lowering 'mongo.input.split_size' if this is undesirable.");
        }
        BasicDBObject lastKey = null;
        for (Object aSplitData : splitData) {
            BasicDBObject currentKey = (BasicDBObject)aSplitData;
            MongoInputSplit split = this.createSplitFromBounds(lastKey, currentKey);
            returnVal.add(split);
            lastKey = currentKey;
        }
        MongoInputSplit lastSplit = this.createSplitFromBounds(lastKey, null);
        returnVal.add(lastSplit);
        return returnVal;
    }
}

