/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MongoClientURIBuilder {
    private MongoClientOptions options;
    private MongoCredential credentials;
    private String host = "localhost";
    private Integer port = 27017;
    private String database;
    private String collection;
    private String userName;
    private String password;
    private Map<String, String> params = new LinkedHashMap<String, String>();

    public MongoClientURIBuilder() {
    }

    public MongoClientURIBuilder(MongoClientURI mongoClientURI) {
        String uri;
        List<String> hosts = mongoClientURI.getHosts();
        if (!hosts.isEmpty()) {
            String first = hosts.get(0);
            if (first.contains("/")) {
                first = first.substring(0, first.indexOf("/"));
            }
            if (first.contains(":")) {
                String[] split = first.split(":");
                this.host = split[0];
                this.port = Integer.valueOf(split[1]);
            } else {
                this.host = first;
            }
        }
        this.database = mongoClientURI.getDatabase();
        this.collection = mongoClientURI.getCollection();
        this.userName = mongoClientURI.getUsername();
        if (mongoClientURI.getPassword() != null) {
            this.password = new String(mongoClientURI.getPassword());
        }
        if ((uri = mongoClientURI.getURI()).contains("?")) {
            String[] pairs;
            String query = uri.substring(uri.indexOf(63) + 1);
            for (String pair : pairs = query.split("&")) {
                String[] split = pair.split("=");
                this.param(split[0], split[1]);
            }
        }
    }

    public MongoClientURIBuilder host(String host) {
        if (host.contains(":")) {
            String[] split = host.split(":");
            this.host = split[0];
            this.port = Integer.valueOf(split[1]);
        } else {
            this.host = host;
        }
        return this;
    }

    public MongoClientURIBuilder port(Integer port) {
        this.port = port;
        return this;
    }

    public MongoClientURIBuilder collection(String database, String collection) {
        this.database = database;
        this.collection = collection;
        return this;
    }

    public MongoClientURIBuilder auth(String userName, String password) {
        this.userName = userName;
        this.password = password;
        this.params.put("authSource", "admin");
        return this;
    }

    public MongoClientURIBuilder options(MongoClientOptions options) {
        this.options = options;
        return this;
    }

    public MongoClientURIBuilder param(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public MongoClientURI build() {
        StringBuilder uri = new StringBuilder(String.format("mongodb://", new Object[0]));
        if (this.userName != null) {
            uri.append(String.format("%s:%s@", this.userName, this.password));
        }
        uri.append(String.format("%s:%d", this.host, this.port));
        if (this.database != null) {
            uri.append(String.format("/%s.%s", this.database, this.collection));
        }
        if (!this.params.isEmpty()) {
            boolean paramAdded = false;
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                uri.append(paramAdded ? "&" : "?");
                paramAdded = true;
                uri.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        return new MongoClientURI(uri.toString());
    }

    public MongoClientURIBuilder readPreference(ReadPreference readPreference) {
        if (!readPreference.equals(ReadPreference.primary())) {
            this.params.put("readPreference", readPreference.toString());
        } else {
            this.params.remove("readPreference");
        }
        return this;
    }
}

