/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import com.mongodb.DBCallback;
import com.mongodb.DBCallbackFactory;
import com.mongodb.DBCollection;
import com.mongodb.DefaultDBCallback;

public class SplitFriendlyDBCallback
extends DefaultDBCallback {
    public static final DBCallbackFactory FACTORY = new SplitFriendlyFactory();
    public static final MinKey MIN_KEY_TYPE = new MinKey();
    public static final MaxKey MAX_KEY_TYPE = new MaxKey();

    public SplitFriendlyDBCallback(DBCollection coll) {
        super(coll);
    }

    @Override
    public void gotMinKey(String name) {
        this.cur().put(name, MAX_KEY_TYPE);
    }

    @Override
    public void gotMaxKey(String name) {
        this.cur().put(name, MAX_KEY_TYPE);
    }

    static class SplitFriendlyFactory
    implements DBCallbackFactory {
        SplitFriendlyFactory() {
        }

        @Override
        public DBCallback create(DBCollection collection) {
            return new DefaultDBCallback(collection);
        }
    }

    static final class MaxKey {
        MaxKey() {
        }
    }

    static final class MinKey {
        MinKey() {
        }
    }
}

